/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container.util;

import java.io.IOException;
import java.io.InputStream;

public final class Utils {
    static final int BLOCK_SIZE = 4096;

    private Utils() {
    }

    public static byte[] streamToByteArray(InputStream istream) throws IOException {
        byte[] tempArray;
        int max = istream.available();
        if (max < 4096) {
            max = 4096;
        }
        byte[] byteArray = new byte[max];
        int off = 0;
        int len = istream.read(byteArray, off, max);
        while (len != -1) {
            if (max - (off += len) < 1024) {
                tempArray = new byte[max *= 2];
                System.arraycopy(byteArray, 0, tempArray, 0, off);
                byteArray = tempArray;
            }
            len = istream.read(byteArray, off, max - off);
        }
        tempArray = new byte[off];
        System.arraycopy(byteArray, 0, tempArray, 0, off);
        byteArray = tempArray;
        return byteArray;
    }

    public static byte[] streamToByteArray(InputStream stream, int len) throws IOException {
        if (len == -1) {
            return Utils.streamToByteArray(stream);
        }
        byte[] byteArray = new byte[len];
        int off = 0;
        int cnt = stream.read(byteArray, off, len - off);
        while (cnt != -1 && off < len) {
            cnt = stream.read(byteArray, off += cnt, len - off);
        }
        if (off != len) {
            byte[] tempArray = new byte[off];
            System.arraycopy(byteArray, 0, tempArray, 0, off);
            byteArray = tempArray;
        }
        return byteArray;
    }
}

