/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.LocallyExposedJmsResourceHolder;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer
implements ExceptionListener {
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private TaskExecutor taskExecutor;
    private Set sessions;
    private Set consumers;
    private final Object consumersMonitor = new Object();

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue(concurrentConsumers > 0, "'concurrentConsumers' value must be at least 1 (one)");
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void validateConfiguration() {
        super.validateConfiguration();
        if (this.isSubscriptionDurable() && this.concurrentConsumers != 1) {
            throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
        }
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    protected void doInitialize() throws JMSException {
        this.establishSharedConnection();
        this.initializeConsumers();
    }

    protected void doStart() throws JMSException {
        super.doStart();
        this.initializeConsumers();
    }

    protected void prepareSharedConnection(Connection connection) throws JMSException {
        super.prepareSharedConnection(connection);
        connection.setExceptionListener((ExceptionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException ex) {
        this.invokeExceptionListener(ex);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Trying to recover from JMS Connection exception: " + (Object)((Object)ex)));
        }
        try {
            Object object = this.consumersMonitor;
            synchronized (object) {
                this.sessions = null;
                this.consumers = null;
            }
            this.refreshSharedConnection();
            this.initializeConsumers();
            this.logger.info((Object)"Successfully refreshed JMS Connection");
        }
        catch (JMSException recoverEx) {
            this.logger.debug((Object)"Failed to recover JMS Connection", (Throwable)recoverEx);
            this.logger.error((Object)"Encountered non-recoverable JMSException", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConsumers() throws JMSException {
        Object object = this.consumersMonitor;
        synchronized (object) {
            if (this.consumers == null) {
                this.sessions = new HashSet(this.concurrentConsumers);
                this.consumers = new HashSet(this.concurrentConsumers);
                Connection con = this.getSharedConnection();
                for (int i = 0; i < this.concurrentConsumers; ++i) {
                    Session session = this.createSession(con);
                    MessageConsumer consumer = this.createListenerConsumer(session);
                    this.sessions.add(session);
                    this.consumers.add(consumer);
                }
            }
        }
    }

    protected MessageConsumer createListenerConsumer(final Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        MessageConsumer consumer = this.createConsumer(session, destination);
        if (this.taskExecutor != null) {
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(final Message message) {
                    SimpleMessageListenerContainer.this.taskExecutor.execute(new Runnable(){

                        public void run() {
                            SimpleMessageListenerContainer.this.processMessage(message, session);
                        }
                    });
                }
            });
        } else {
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    SimpleMessageListenerContainer.this.processMessage(message, session);
                }
            });
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(Message message, Session session) {
        boolean exposeResource = this.isExposeListenerSession();
        if (exposeResource) {
            TransactionSynchronizationManager.bindResource(this.getConnectionFactory(), new LocallyExposedJmsResourceHolder(session));
        }
        try {
            this.executeListener(session, message);
        }
        finally {
            if (exposeResource) {
                TransactionSynchronizationManager.unbindResource(this.getConnectionFactory());
            }
        }
    }

    protected void doShutdown() throws JMSException {
        this.logger.debug((Object)"Closing JMS MessageConsumers");
        Iterator it = this.consumers.iterator();
        while (it.hasNext()) {
            MessageConsumer consumer = (MessageConsumer)it.next();
            JmsUtils.closeMessageConsumer(consumer);
        }
        this.logger.debug((Object)"Closing JMS Sessions");
        it = this.sessions.iterator();
        while (it.hasNext()) {
            Session session = (Session)it.next();
            JmsUtils.closeSession(session);
        }
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isSubscriptionDurable() && destination instanceof Topic) {
                return session.createDurableSubscriber((Topic)destination, this.getDurableSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }
}

