/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$SignatureProcessor == null ? (class$org$apache$ws$security$processor$SignatureProcessor = SignatureProcessor.class$("org.apache.ws.security.processor.SignatureProcessor")) : class$org$apache$ws$security$processor$SignatureProcessor).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private String signatureId;
    static /* synthetic */ Class class$org$apache$ws$security$processor$SignatureProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found signature element");
        }
        WSDocInfoStore.store(wsDocInfo);
        X509Certificate[] returnCert = new X509Certificate[1];
        HashSet returnElements = new HashSet();
        TreeSet protectedElements = new TreeSet();
        byte[][] signatureValue = new byte[1][];
        Principal lastPrincipalFound = null;
        try {
            lastPrincipalFound = this.verifyXMLSignature(elem, crypto, returnCert, returnElements, protectedElements, signatureValue, cb);
        }
        catch (WSSecurityException ex) {
            throw ex;
        }
        finally {
            WSDocInfoStore.delete(wsDocInfo);
        }
        if (lastPrincipalFound instanceof WSUsernameTokenPrincipal) {
            returnResults.add(0, new WSSecurityEngineResult(64, lastPrincipalFound, null, returnElements, protectedElements, signatureValue[0]));
        } else {
            returnResults.add(0, new WSSecurityEngineResult(2, lastPrincipalFound, returnCert[0], returnElements, protectedElements, signatureValue[0]));
        }
        this.signatureId = elem.getAttributeNS(null, "Id");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Set returnElements, Set protectedElements, byte[][] signatureValue, CallbackHandler cb) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Verify XML Signature");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSecurityException e2) {
            throw new WSSecurityException(6, "noXMLSig", null, e2);
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        X509Certificate[] certs = null;
        KeyInfo info = sig.getKeyInfo();
        byte[] secretKey = null;
        UsernameToken ut = null;
        DerivedKeyToken dkt = null;
        SAMLKeyInfo samlKi = null;
        String customTokenId = null;
        if (info != null) {
            Node node = WSSecurityUtil.getDirectChild(info.getElement(), "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference((Element)node);
            int docHash = elem.getOwnerDocument().hashCode();
            WSDocInfo wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (secRef.containsReference()) {
                String id;
                Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo, cb);
                QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                if (el.equals(WSSecurityEngine.usernameToken)) {
                    id = token.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    UsernameTokenProcessor utProcessor = (UsernameTokenProcessor)wsDocInfo.getProcessor(id);
                    ut = utProcessor.getUt();
                    secretKey = ut.isDerivedKey() ? ut.getDerivedKey() : ut.getSecretKey();
                } else if (el.equals(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02) || el.equals(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12)) {
                    dkt = new DerivedKeyToken(token);
                    id = dkt.getID();
                    DerivedKeyTokenProcessor dktProcessor = (DerivedKeyTokenProcessor)wsDocInfo.getProcessor(id);
                    String signatureMethodURI = sig.getSignedInfo().getSignatureMethodURI();
                    int keyLength = dkt.getLength() > 0 ? dkt.getLength() : WSSecurityUtil.getKeyLength(signatureMethodURI);
                    secretKey = dktProcessor.getKeyBytes(keyLength);
                } else if (el.equals(WSSecurityEngine.binaryToken)) {
                    certs = this.getCertificatesTokenReference(token, crypto);
                } else if (el.equals(WSSecurityEngine.SAML_TOKEN)) {
                    if (crypto == null) {
                        throw new WSSecurityException(0, "noSigCryptoFile");
                    }
                    samlKi = SAMLUtil.getSAMLKeyInfo(token, crypto, cb);
                    certs = samlKi.getCerts();
                    secretKey = samlKi.getSecret();
                } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                    String encryptedKeyID = token.getAttributeNS(null, "Id");
                    EncryptedKeyProcessor encryptKeyProcessor = (EncryptedKeyProcessor)wsDocInfo.getProcessor(encryptedKeyID);
                    if (encryptKeyProcessor == null) {
                        if (crypto == null) {
                            throw new WSSecurityException(0, "noSigCryptoFile");
                        }
                        encryptKeyProcessor = new EncryptedKeyProcessor();
                        encryptKeyProcessor.handleEncryptedKey(token, cb, crypto);
                    }
                    secretKey = encryptKeyProcessor.getDecryptedBytes();
                } else {
                    id = secRef.getReference().getURI().substring(1);
                    WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                    try {
                        cb.handle(new Callback[]{pwcb});
                    }
                    catch (Exception e) {
                        throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                    }
                    secretKey = pwcb.getKey();
                    customTokenId = id;
                    if (secretKey == null) {
                        throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{el.toString()});
                    }
                }
            } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                certs = secRef.getX509IssuerSerial(crypto);
            } else {
                if (!secRef.containsKeyIdentifier()) throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{node.toString()});
                if (secRef.getKeyIdentifierValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                    String id = secRef.getKeyIdentifierValue();
                    WSPasswordCallback pwcb = new WSPasswordCallback(id, null, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", 8);
                    try {
                        cb.handle(new Callback[]{pwcb});
                    }
                    catch (Exception e) {
                        throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                    }
                    secretKey = pwcb.getKey();
                } else {
                    certs = secRef.getKeyIdentifier(crypto);
                }
            }
        } else {
            if (crypto == null) {
                throw new WSSecurityException(0, "noSigCryptoFile");
            }
            if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "unsupportedKeyInfo");
            certs = crypto.getCertificates(crypto.getDefaultX509Alias());
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if ((certs == null || certs.length == 0 || certs[0] == null) && secretKey == null) {
            throw new WSSecurityException(6);
        }
        if (certs != null) {
            try {
                certs[0].checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new WSSecurityException(6, "invalidCert", null, e);
            }
            catch (CertificateNotYetValidException e) {
                throw new WSSecurityException(6, "invalidCert", null, e);
            }
        }
        try {
            boolean signatureOk = false;
            signatureOk = certs != null ? sig.checkSignatureValue(certs[0]) : sig.checkSignatureValue((Key)sig.createSecretKey(secretKey));
            if (!signatureOk) throw new WSSecurityException(6);
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Verify: total= " + (t2 - t0) + ", prepare-cert= " + (t1 - t0) + ", verify= " + (t2 - t1)));
            }
            signatureValue[0] = sig.getSignatureValue();
            SignedInfo si = sig.getSignedInfo();
            int numReferences = si.getLength();
            for (int i = 0; i < numReferences; ++i) {
                Reference siRef;
                try {
                    siRef = si.item(i);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(6, null, null, e3);
                }
                String uri = siRef.getURI();
                if (uri != null && !"".equals(uri)) {
                    Element se = WSSecurityUtil.getElementByWsuId(elem.getOwnerDocument(), uri);
                    if (se == null) {
                        se = WSSecurityUtil.getElementByGenId(elem.getOwnerDocument(), uri);
                    }
                    if (se == null) {
                        throw new WSSecurityException(6);
                    }
                    returnElements.add(WSSecurityUtil.getIDFromReference(uri));
                    continue;
                }
                returnElements.add(siRef);
            }
            if (certs != null) {
                returnCert[0] = certs[0];
                return certs[0].getSubjectDN();
            }
            if (ut != null) {
                WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
                principal.setNonce(ut.getNonce());
                principal.setPassword(ut.getPassword());
                principal.setCreatedTime(ut.getCreated());
                return principal;
            }
            if (dkt != null) {
                WSDerivedKeyTokenPrincipal principal = new WSDerivedKeyTokenPrincipal(dkt.getID());
                principal.setNonce(dkt.getNonce());
                principal.setLabel(dkt.getLabel());
                principal.setLength(dkt.getLength());
                principal.setOffset(dkt.getOffset());
                String basetokenId = null;
                SecurityTokenReference securityTokenReference = dkt.getSecurityTokenReference();
                basetokenId = securityTokenReference.containsReference() ? securityTokenReference.getReference().getURI().substring(1) : securityTokenReference.getKeyIdentifierValue();
                principal.setBasetokenId(basetokenId);
                return principal;
            }
            if (samlKi != null) {
                SAMLAssertion assertion = samlKi.getAssertion();
                CustomTokenPrincipal principal = new CustomTokenPrincipal(assertion.getId());
                principal.setTokenObject(assertion);
                return principal;
            }
            if (secretKey == null) throw new WSSecurityException("Cannot determine principal");
            return new CustomTokenPrincipal(customTokenId);
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6, null, null, e1);
        }
    }

    public X509Certificate[] getCertificatesTokenReference(Element elem, Crypto crypto) throws WSSecurityException {
        if (crypto == null) {
            throw new WSSecurityException(0, "noSigCryptoFile");
        }
        BinarySecurity token = this.createSecurityToken(elem);
        if (token instanceof PKIPathSecurity) {
            return ((PKIPathSecurity)token).getX509Certificates(false, crypto);
        }
        if (token instanceof X509Security) {
            X509Certificate cert = ((X509Security)token).getX509Certificate(crypto);
            X509Certificate[] certs = new X509Certificate[]{cert};
            return certs;
        }
        return null;
    }

    private BinarySecurity createSecurityToken(Element element) throws WSSecurityException {
        BinarySecurity token = new BinarySecurity(element);
        String type = token.getValueType();
        X509Security x509 = null;
        PKIPathSecurity pkiPath = null;
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(type)) {
            x509 = new X509Security(element);
            return x509;
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1".equals(type)) {
            x509 = new X509Security(element);
            return x509;
        }
        if (PKIPathSecurity.getType().equals(type)) {
            pkiPath = new PKIPathSecurity(element);
            return pkiPath;
        }
        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
    }

    public String getId() {
        return this.signatureId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

