/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.AbstractServiceFactory;
import org.apache.cxf.service.ServiceBuilder;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.processor.FrontendFactory;
import org.apache.cxf.tools.util.NameUtil;
import org.springframework.context.ApplicationContext;

public final class ServiceBuilderFactory {
    private static ServiceBuilderFactory instance;
    private static FrontendFactory frontend;
    private static String databindingName;
    private Class serviceClass;

    private ServiceBuilderFactory() {
        frontend = FrontendFactory.getInstance();
        databindingName = "jaxb";
    }

    public static ServiceBuilderFactory getInstance() {
        if (instance == null) {
            instance = new ServiceBuilderFactory();
        }
        return instance;
    }

    public ServiceBuilder newBuilder(ApplicationContext applicationContext) {
        return this.newBuilder(applicationContext, this.getStyle());
    }

    public static String databindingNameToBeanName(String dbName) {
        return NameUtil.capitalize(dbName.toLowerCase()) + "DatabindingBean";
    }

    public ServiceBuilder newBuilder(ApplicationContext applicationContext, FrontendFactory.Style s) {
        DataBinding dataBinding;
        String databindingBeanName = ServiceBuilderFactory.databindingNameToBeanName(databindingName);
        try {
            dataBinding = (DataBinding)applicationContext.getBean(databindingBeanName);
        }
        catch (RuntimeException e) {
            throw new ToolException("Cannot get databinding bean " + databindingBeanName + " for databinding " + databindingName);
        }
        String beanName = this.getBuilderBeanName(s);
        ServiceBuilder builder = null;
        try {
            builder = (ServiceBuilder)applicationContext.getBean(beanName, ServiceBuilder.class);
            AbstractServiceFactory serviceFactory = (AbstractServiceFactory)builder;
            serviceFactory.setDataBinding(dataBinding);
        }
        catch (RuntimeException e) {
            throw new ToolException("Can not get ServiceBuilder bean " + beanName + "to initialize the ServiceBuilder for style: " + (Object)((Object)s) + " Reason: \n" + e.getMessage(), (Throwable)e);
        }
        builder.setServiceClass(this.serviceClass);
        return builder;
    }

    protected String getBuilderBeanName(FrontendFactory.Style s) {
        return (Object)((Object)s) + "ServiceBuilderBean";
    }

    public FrontendFactory.Style getStyle() {
        frontend.setServiceClass(this.serviceClass);
        return frontend.discoverStyle();
    }

    public void setServiceClass(Class c) {
        this.serviceClass = c;
    }

    public String getDatabindingName() {
        return databindingName;
    }

    public void setDatabindingName(String arg) {
        databindingName = arg;
    }
}

