/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URITemplate {
    public static final String TEMPLATE_PARAMETERS = "jaxrs.template.parameters";
    public static final String LIMITED_REGEX_SUFFIX = "(/.*)?";
    public static final String UNLIMITED_REGEX_SUFFIX = "(/)?";
    public static final String FINAL_MATCH_GROUP = "FINAL_MATCH_GROUP";
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{(\\w[-\\w\\.]*)(\\:(.+?))?\\}");
    private static final String DEFAULT_PATH_VARIABLE_REGEX = "([^/]+?)";
    private static final String PATH_UNLIMITED_VARIABLE_REGEX = "(.*?)";
    private static final String CHARACTERS_TO_ESCAPE = ".";
    private final String template;
    private final List<String> templateVariables = new ArrayList<String>();
    private final List<String> customTemplateVariables = new ArrayList<String>();
    private final Pattern templateRegexPattern;
    private final String literals;

    public URITemplate(String theTemplate) {
        this(theTemplate, true);
    }

    public URITemplate(String theTemplate, boolean limited) {
        boolean endsWithSlash;
        String substr;
        this.template = theTemplate;
        StringBuilder literalChars = new StringBuilder();
        StringBuilder patternBuilder = new StringBuilder();
        Matcher matcher = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        int i = 0;
        while (matcher.find()) {
            this.templateVariables.add(matcher.group(1).trim());
            substr = URITemplate.escapeCharacters(this.template.substring(i, matcher.start()));
            literalChars.append(substr);
            patternBuilder.append(substr);
            i = matcher.end();
            if (matcher.group(2) != null && matcher.group(3) != null) {
                patternBuilder.append('(');
                patternBuilder.append(matcher.group(3).trim());
                patternBuilder.append(')');
                this.customTemplateVariables.add(matcher.group(1).trim());
                continue;
            }
            if (!limited && i == this.template.length()) {
                patternBuilder.append(PATH_UNLIMITED_VARIABLE_REGEX);
                continue;
            }
            patternBuilder.append(DEFAULT_PATH_VARIABLE_REGEX);
        }
        substr = URITemplate.escapeCharacters(this.template.substring(i, this.template.length()));
        literalChars.append(substr);
        patternBuilder.append(substr);
        this.literals = literalChars.toString();
        int endPos = patternBuilder.length() - 1;
        boolean bl = endPos >= 0 ? patternBuilder.charAt(endPos) == '/' : (endsWithSlash = false);
        if (endsWithSlash) {
            patternBuilder.deleteCharAt(endPos);
        }
        patternBuilder.append(limited ? LIMITED_REGEX_SUFFIX : UNLIMITED_REGEX_SUFFIX);
        this.templateRegexPattern = Pattern.compile(patternBuilder.toString());
    }

    public String getLiteralChars() {
        return this.literals;
    }

    public String getValue() {
        return this.template;
    }

    public List<String> getVariables() {
        return Collections.unmodifiableList(this.templateVariables);
    }

    public List<String> getCustomVariables() {
        return Collections.unmodifiableList(this.customTemplateVariables);
    }

    private static String escapeCharacters(String expression) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            sb.append(URITemplate.isReservedCharacter(ch) ? "\\" + ch : Character.valueOf(ch));
        }
        return sb.toString();
    }

    private static boolean isReservedCharacter(char ch) {
        return CHARACTERS_TO_ESCAPE.indexOf(ch) != -1;
    }

    public boolean match(String uri, MultivaluedMap<String, String> templateVariableToValue) {
        if (uri == null) {
            return this.templateRegexPattern == null;
        }
        if (this.templateRegexPattern == null) {
            return false;
        }
        Matcher m = this.templateRegexPattern.matcher(uri);
        if (!m.matches()) {
            if (uri.contains(";")) {
                List<PathSegment> pList = JAXRSUtils.getPathSegments(this.template, false);
                List<PathSegment> uList = JAXRSUtils.getPathSegments(uri, false);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < uList.size(); ++i) {
                    sb.append('/');
                    if (pList.size() > i && pList.get(i).getPath().indexOf(123) == -1) {
                        sb.append(uList.get(i).getPath());
                        continue;
                    }
                    sb.append(HttpUtils.fromPathSegment(uList.get(i)));
                }
                uri = sb.toString();
                m = this.templateRegexPattern.matcher(uri);
                if (!m.matches()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        int i = 1;
        for (String name : this.templateVariables) {
            String value = m.group(i++);
            templateVariableToValue.add((Object)name, (Object)value);
        }
        String finalGroup = m.group(i);
        templateVariableToValue.putSingle((Object)FINAL_MATCH_GROUP, (Object)(finalGroup == null ? "/" : finalGroup));
        return true;
    }

    public String substitute(List<String> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        Iterator<String> valIter = values.iterator();
        StringBuffer sb = new StringBuffer();
        while (m.find() && valIter.hasNext()) {
            Pattern p;
            String value = valIter.next();
            String varPattern = m.group(2);
            if (varPattern != null && !(p = Pattern.compile(varPattern)).matcher(":" + value).matches()) {
                throw new IllegalArgumentException("Value '" + value + "' does not match variable " + m.group());
            }
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String substitute(Map<String, ? extends Object> valuesMap) throws IllegalArgumentException {
        if (valuesMap == null) {
            throw new IllegalArgumentException("valuesMap is null");
        }
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            Pattern p;
            Object value = valuesMap.get(m.group(1));
            if (value == null) continue;
            String sval = value.toString();
            String varPattern = m.group(2);
            if (varPattern != null && !(p = Pattern.compile(varPattern)).matcher(":" + sval).matches()) {
                throw new IllegalArgumentException("Value '" + sval + "' does not match variable " + m.group());
            }
            m.appendReplacement(sb, sval);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static URITemplate createTemplate(ClassResourceInfo cri, Path path) {
        if (path == null) {
            return new URITemplate("/");
        }
        String pathValue = path.value();
        if (!pathValue.startsWith("/")) {
            pathValue = "/" + pathValue;
        }
        return new URITemplate(pathValue, path.limited());
    }

    public static int compareTemplates(URITemplate t1, URITemplate t2) {
        int gCustom2;
        int gCustom1;
        int result;
        int g2;
        String l2;
        String l1 = t1.getLiteralChars();
        if (!l1.equals(l2 = t2.getLiteralChars())) {
            return l1.length() < l2.length() ? 1 : -1;
        }
        int g1 = t1.templateVariables.size();
        int n = g1 < (g2 = t2.templateVariables.size()) ? 1 : (result = g1 > g2 ? -1 : 0);
        if (result == 0 && (gCustom1 = t1.customTemplateVariables.size()) != (gCustom2 = t2.customTemplateVariables.size())) {
            return gCustom1 < gCustom2 ? 1 : -1;
        }
        return result;
    }
}

