/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.io.UnsupportedEncodingException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WSSecDerivedKeyBase
extends WSSecBase {
    protected Document document;
    protected byte[] ephemeralKey;
    protected DerivedKeyToken dkt = null;
    protected byte[] derivedKeyBytes = null;
    protected String dktId = null;
    protected String clientLabel = "WS-SecureConversation";
    protected String serviceLabel = "WS-SecureConversation";
    protected Element envelope = null;
    protected String tokenIdentifier = null;
    protected Element strElem;
    private int wscVersion = 1;
    protected int derivedKeyLength = -1;
    private String customValueType;

    protected abstract int getDerivedKeyLength() throws WSSecurityException;

    public void setExternalKey(byte[] ephemeralKey, String tokenIdentifier) {
        this.ephemeralKey = ephemeralKey;
        this.tokenIdentifier = tokenIdentifier;
    }

    public void setExternalKey(byte[] ephemeralKey, Element strElem) {
        this.ephemeralKey = ephemeralKey;
        this.strElem = strElem;
    }

    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    public String getId() {
        return this.dktId;
    }

    public void setClientLabel(String clientLabel) {
        this.clientLabel = clientLabel;
    }

    public void setServiceLabel(String serviceLabel) {
        this.serviceLabel = serviceLabel;
    }

    public void prepare(Document doc) throws WSSecurityException, ConversationException {
        byte[] label;
        this.document = doc;
        int offset = 0;
        int length = this.getDerivedKeyLength();
        try {
            label = (this.clientLabel + this.serviceLabel).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WSSecurityException("UTF-8 encoding is not supported", e);
        }
        byte[] nonce = WSSecurityUtil.generateNonce(16);
        byte[] seed = new byte[label.length + nonce.length];
        System.arraycopy(label, 0, seed, 0, label.length);
        System.arraycopy(nonce, 0, seed, label.length, nonce.length);
        DerivationAlgorithm algo = AlgoFactory.getInstance("http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1");
        this.derivedKeyBytes = algo.createKey(this.ephemeralKey, seed, offset, length);
        this.dkt = new DerivedKeyToken(this.wscVersion, this.document);
        this.dktId = "derivedKeyId-" + this.dkt.hashCode();
        this.dkt.setOffset(offset);
        this.dkt.setLength(length);
        this.dkt.setNonce(Base64.encode((byte[])nonce));
        this.dkt.setID(this.dktId);
        if (this.strElem == null) {
            SecurityTokenReference strEncKey = new SecurityTokenReference(this.document);
            Reference ref = new Reference(this.document);
            ref.setURI("#" + this.tokenIdentifier);
            if (this.customValueType != null && this.customValueType.trim().length() > 0) {
                ref.setValueType(this.customValueType);
            }
            strEncKey.setReference(ref);
            this.dkt.setSecurityTokenReference(strEncKey);
        } else {
            this.dkt.setSecurityTokenReference(this.strElem);
        }
    }

    public void prependDKElementToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.dkt.getElement());
    }

    public void appendDKElementToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.dkt.getElement());
    }

    public void setWscVersion(int wscVersion) {
        this.wscVersion = wscVersion;
    }

    public Element getdktElement() {
        return this.dkt.getElement();
    }

    public void setDerivedKeyLength(int keyLength) {
        this.derivedKeyLength = keyLength;
    }

    public void setCustomValueType(String customValueType) {
        this.customValueType = customValueType;
    }
}

