/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDisposition {
    private List<String> values;

    public ContentDisposition(String value) {
        this.values = Arrays.asList(value.split(";"));
    }

    public String getType() {
        return this.values.get(0).trim();
    }

    public String getParameter(String name) {
        for (int i = 1; i < this.values.size(); ++i) {
            String v = this.values.get(i).trim();
            if (!v.startsWith(name)) continue;
            String[] parts = v.split("=");
            return parts.length == 2 ? parts[1].trim() : "";
        }
        return null;
    }

    public Map<String, String> getParameters() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 1; i < this.values.size(); ++i) {
            String[] parts = this.values.get(i).split("=");
            map.put(parts[0].trim(), parts.length == 2 ? parts[1].trim() : "");
        }
        return map;
    }
}

