/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.xml.sax.InputSource;

public class TransportURIResolver
extends ExtendedURIResolver {
    protected Bus bus;

    public TransportURIResolver(Bus b) {
        this.bus = b;
    }

    public InputSource resolve(String curUri, String baseUri) {
        URI base;
        InputSource is = null;
        try {
            if (baseUri == null) {
                base = new URI(curUri);
            } else {
                base = new URI(baseUri);
                base = base.resolve(curUri);
            }
        }
        catch (URISyntaxException use) {
            base = null;
        }
        try {
            if (base == null || !"https".equals(base.getScheme())) {
                is = super.resolve(curUri, baseUri);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (is == null && base != null && base.getScheme() != null) {
            try {
                ConduitInitiator ci = this.bus.getExtension(ConduitInitiatorManager.class).getConduitInitiatorForUri(base.toString());
                EndpointInfo info = new EndpointInfo();
                info.setAddress(base.toString());
                final Conduit c = ci.getConduit(info);
                MessageImpl message = new MessageImpl();
                ExchangeImpl exch = new ExchangeImpl();
                message.setExchange(exch);
                message.put(Message.HTTP_REQUEST_METHOD, "GET");
                c.setMessageObserver(new MessageObserver(){

                    public void onMessage(Message message) {
                        LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
                        try {
                            IOUtils.copy(message.getContent(InputStream.class), bout);
                            message.getExchange().put(InputStream.class, bout.createInputStream());
                            c.close(message);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                c.prepare(message);
                c.close(message);
                InputStream ins = exch.get(InputStream.class);
                this.resourceOpened.addElement(ins);
                InputSource src = new InputSource(ins);
                src.setPublicId(base.toString());
                src.setSystemId(base.toString());
                this.lastestImportUri = base.toString();
                this.currentResolver.unresolve();
                return src;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null && "https".equals(base.getScheme())) {
            is = super.resolve(curUri, baseUri);
        }
        return is;
    }
}

