/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import com.ibm.wsspi.uow.UOWAction;
import com.ibm.wsspi.uow.UOWActionException;
import com.ibm.wsspi.uow.UOWException;
import com.ibm.wsspi.uow.UOWManager;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaAfterCompletionSynchronization;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.JtaTransactionObject;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class WebSphereUowTransactionManager
extends JtaTransactionManager
implements CallbackPreferringPlatformTransactionManager {
    public static final String DEFAULT_UOW_MANAGER_NAME = "java:comp/websphere/UOWManager";
    private UOWManager uowManager;
    private String uowManagerName = "java:comp/websphere/UOWManager";

    public WebSphereUowTransactionManager() {
        this.setAutodetectTransactionManager(false);
    }

    public WebSphereUowTransactionManager(UOWManager uowManager) {
        this();
        this.uowManager = uowManager;
    }

    public void setUowManager(UOWManager uowManager) {
        this.uowManager = uowManager;
    }

    public void setUowManagerName(String uowManagerName) {
        this.uowManagerName = uowManagerName;
    }

    public void afterPropertiesSet() throws TransactionSystemException {
        this.initUserTransactionAndTransactionManager();
        if (this.uowManager == null) {
            if (this.uowManagerName != null) {
                this.uowManager = this.lookupUowManager(this.uowManagerName);
            } else {
                throw new IllegalStateException("'uowManager' or 'uowManagerName' is required");
            }
        }
    }

    protected UOWManager lookupUowManager(String uowManagerName) throws TransactionSystemException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving WebSphere UOWManager from JNDI location [" + uowManagerName + "]"));
            }
            return (UOWManager)this.getJndiTemplate().lookup(uowManagerName, UOWManager.class);
        }
        catch (NamingException ex) {
            throw new TransactionSystemException("WebSphere UOWManager is not available at JNDI location [" + uowManagerName + "]", ex);
        }
    }

    protected void doRegisterAfterCompletionWithJtaTransaction(JtaTransactionObject txObject, List synchronizations) {
        this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
    }

    public Object execute(TransactionDefinition definition, TransactionCallback callback) throws TransactionException {
        if (definition == null) {
            definition = new DefaultTransactionDefinition();
        }
        if (definition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
        }
        int pb = definition.getPropagationBehavior();
        boolean existingTx = this.uowManager.getUOWStatus() != 5 && this.uowManager.getUOWType() != 0;
        int uowType = 1;
        boolean joinTx = false;
        boolean newSynch = false;
        if (existingTx) {
            if (pb == 5) {
                throw new IllegalTransactionStateException("Transaction propagation 'never' but existing transaction found");
            }
            if (pb == 6) {
                throw new NestedTransactionNotSupportedException("Transaction propagation 'nested' not supported for WebSphere UOW transactions");
            }
            if (pb == 1 || pb == 0 || pb == 2) {
                joinTx = true;
                newSynch = this.getTransactionSynchronization() != 2;
            } else if (pb == 4) {
                uowType = 0;
                newSynch = this.getTransactionSynchronization() == 0;
            } else {
                newSynch = this.getTransactionSynchronization() != 2;
            }
        } else {
            if (pb == 2) {
                throw new IllegalTransactionStateException("Transaction propagation 'mandatory' but no existing transaction found");
            }
            if (pb == 1 || pb == 4 || pb == 5) {
                uowType = 0;
                newSynch = this.getTransactionSynchronization() == 0;
            } else {
                newSynch = this.getTransactionSynchronization() != 2;
            }
        }
        boolean debug = this.logger.isDebugEnabled();
        if (debug) {
            this.logger.debug((Object)("Creating new transaction with name [" + definition.getName() + "]: " + definition));
        }
        AbstractPlatformTransactionManager.SuspendedResourcesHolder suspendedResources = existingTx && !joinTx ? this.suspend(null) : null;
        try {
            if (definition.getTimeout() > -1) {
                this.uowManager.setUOWTimeout(uowType, definition.getTimeout());
            }
            if (debug) {
                this.logger.debug((Object)("Invoking WebSphere UOW action: type=" + uowType + ", join=" + joinTx));
            }
            UOWActionAdapter action = new UOWActionAdapter(definition, callback, uowType == 1, !joinTx, newSynch, debug);
            this.uowManager.runUnderUOW(uowType, joinTx, (UOWAction)action);
            if (debug) {
                this.logger.debug((Object)("Returned from WebSphere UOW action: type=" + uowType + ", join=" + joinTx));
            }
            Object object = action.getResult();
            return object;
        }
        catch (UOWException ex) {
            throw new TransactionSystemException("UOWManager transaction processing failed", ex);
        }
        catch (UOWActionException ex) {
            throw new TransactionSystemException("UOWManager threw unexpected UOWActionException", ex);
        }
        finally {
            if (suspendedResources != null) {
                this.resume(null, suspendedResources);
            }
        }
    }

    private class UOWActionAdapter
    implements UOWAction {
        private final TransactionDefinition definition;
        private final TransactionCallback callback;
        private final boolean actualTransaction;
        private final boolean newTransaction;
        private final boolean newSynchronization;
        private boolean debug;
        private Object result;

        public UOWActionAdapter(TransactionDefinition definition, TransactionCallback callback, boolean actualTransaction, boolean newTransaction, boolean newSynchronization, boolean debug) {
            this.definition = definition;
            this.callback = callback;
            this.actualTransaction = actualTransaction;
            this.newTransaction = newTransaction;
            this.newSynchronization = newSynchronization;
            this.debug = debug;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultTransactionStatus status = WebSphereUowTransactionManager.this.newTransactionStatus(this.definition, this.actualTransaction ? this : null, this.newTransaction, this.newSynchronization, this.debug, null);
            try {
                this.result = this.callback.doInTransaction(status);
                WebSphereUowTransactionManager.this.triggerBeforeCommit(status);
            }
            finally {
                if (status.isLocalRollbackOnly()) {
                    if (status.isDebug()) {
                        WebSphereUowTransactionManager.this.logger.debug((Object)"Transactional code has requested rollback");
                    }
                    WebSphereUowTransactionManager.this.uowManager.setRollbackOnly();
                }
                WebSphereUowTransactionManager.this.triggerBeforeCompletion(status);
                if (status.isNewSynchronization()) {
                    List synchronizations = TransactionSynchronizationManager.getSynchronizations();
                    TransactionSynchronizationManager.clear();
                    WebSphereUowTransactionManager.this.uowManager.registerInterposedSynchronization((Synchronization)new JtaAfterCompletionSynchronization(synchronizations));
                }
            }
        }

        public Object getResult() {
            return this.result;
        }
    }
}

