/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingInInterceptor.class);
    private int limit = 102400;
    private PrintWriter writer;

    public LoggingInInterceptor() {
        super("receive");
    }

    public LoggingInInterceptor(String phase) {
        super(phase);
    }

    public LoggingInInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LoggingInInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public void setPrintWriter(PrintWriter w) {
        this.writer = w;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.writer != null || LOG.isLoggable(Level.INFO)) {
            this.logging(message);
        }
    }

    private void logging(Message message) throws Fault {
        InputStream is;
        Object headers;
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------");
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((is = (InputStream)message.getContent(InputStream.class)) != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, (Object)bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                bos.writeCacheTo(buffer.getPayload(), this.limit);
                bos.close();
            }
            catch (IOException e) {
                throw new Fault((Throwable)e);
            }
        }
        if (this.writer != null) {
            this.writer.println(buffer.toString());
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info(buffer.toString());
        }
    }
}

