/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intersector {
    private AssertionBuilderRegistry assertionBuilderRegistry;
    private boolean strict;

    public Intersector(AssertionBuilderRegistry abr) {
        this.assertionBuilderRegistry = abr;
        this.strict = true;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean s) {
        this.strict = s;
    }

    boolean compatibleAssertions(PolicyAssertion a1, PolicyAssertion a2) {
        AssertionBuilder ab = (AssertionBuilder)this.assertionBuilderRegistry.get(a1.getName());
        if (null == ab) {
            return false;
        }
        return null != ab.buildCompatible(a1, a2);
    }

    boolean compatibleAlternatives(Collection<PolicyAssertion> alt1, Collection<PolicyAssertion> alt2) {
        if (alt1.isEmpty() || alt2.isEmpty()) {
            return true;
        }
        if (this.strict) {
            for (PolicyAssertion a1 : alt1) {
                if (null != this.findCompatibleAssertion(a1, alt2)) continue;
                return false;
            }
            for (PolicyAssertion a2 : alt2) {
                if (null != this.findCompatibleAssertion(a2, alt1)) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException("Lax intersection of assertions is not supported because the Ignorable attribute is not supported.");
    }

    boolean compatiblePolicies(Policy p1, Policy p2) {
        Iterator i1 = p1.getAlternatives();
        if (i1.hasNext()) {
            Collection alt1 = CastUtils.cast((Collection)((Collection)i1.next()), PolicyAssertion.class);
            Iterator i2 = p2.getAlternatives();
            while (i2.hasNext()) {
                Collection alt2 = CastUtils.cast((Collection)((Collection)i2.next()), PolicyAssertion.class);
                if (!this.compatibleAlternatives(alt1, alt2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public PolicyAssertion intersect(PolicyAssertion a1, PolicyAssertion a2) {
        AssertionBuilder ab = (AssertionBuilder)this.assertionBuilderRegistry.get(a1.getName());
        if (null == ab) {
            return null;
        }
        return ab.buildCompatible(a1, a2);
    }

    public Collection<PolicyAssertion> intersect(Collection<PolicyAssertion> alt1, Collection<PolicyAssertion> alt2) {
        if (!this.compatibleAlternatives(alt1, alt2)) {
            return null;
        }
        ArrayList<PolicyAssertion> intersection = new ArrayList<PolicyAssertion>();
        intersection.addAll(alt1);
        intersection.addAll(alt2);
        return intersection;
    }

    public Policy intersect(Policy p1, Policy p2) {
        if (!this.compatiblePolicies(p1, p2)) {
            return null;
        }
        Policy compatible = new Policy();
        ExactlyOne eo = new ExactlyOne();
        Iterator i1 = p1.getAlternatives();
        while (i1.hasNext()) {
            List alt1 = CastUtils.cast((List)((List)i1.next()), PolicyAssertion.class);
            Iterator i2 = p2.getAlternatives();
            while (i2.hasNext()) {
                List alt2 = CastUtils.cast((List)((List)i2.next()), PolicyAssertion.class);
                if (!this.compatibleAlternatives(alt1, alt2)) continue;
                All all = new All();
                all.addPolicyComponents(alt1);
                all.addPolicyComponents(alt2);
                eo.addPolicyComponent((PolicyComponent)all);
            }
        }
        if (!eo.isEmpty()) {
            compatible.addPolicyComponent((PolicyComponent)eo);
        }
        return compatible;
    }

    private PolicyAssertion findCompatibleAssertion(PolicyAssertion assertion, Collection<PolicyAssertion> alt) {
        for (PolicyAssertion a : alt) {
            PolicyAssertion compatible = this.intersect(assertion, a);
            if (null == compatible) continue;
            return compatible;
        }
        return null;
    }
}

