/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jbi.ServiceConsumer;
import org.apache.cxf.jbi.se.CXFServiceUnitManager;
import org.apache.cxf.jbi.se.ComponentClassLoader;
import org.apache.cxf.jbi.se.WebServiceClassFinder;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CXFServiceUnit {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFServiceUnit.class);
    private final Bus bus;
    private Object serviceImplementation;
    private ServiceConsumer serviceConsumer;
    private EndpointImpl endpoint;
    private final String rootPath;
    private final ClassLoader parentLoader;
    private boolean isProvider;
    private QName serviceName;
    private String endpointName;
    private ServiceEndpoint ref;

    public CXFServiceUnit(Bus b, String path, ComponentClassLoader parent) {
        URL url = null;
        try {
            url = new File(path + File.separator).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.SEVERE, new Message("SU.FAILED.INIT", LOG, new Object[0]).toString(), ex);
        }
        this.bus = b;
        this.rootPath = path;
        parent.addResource(url);
        this.parentLoader = parent;
        this.parseJbiDescriptor();
    }

    public boolean isServiceProvider() {
        return this.isProvider;
    }

    public void stop(ComponentContext ctx) {
        if (this.ref != null) {
            try {
                ctx.deactivateEndpoint(this.ref);
            }
            catch (JBIException e) {
                LOG.severe(new Message("SU.FAILED.DEACTIVATE.ENDPOINT", LOG, new Object[0]).toString() + this.ref + (Object)((Object)e));
            }
        } else {
            this.serviceConsumer.stop();
        }
    }

    public void start(ComponentContext ctx, CXFServiceUnitManager serviceUnitManager) {
        if (this.isServiceProvider()) {
            LOG.info(new Message("SU.START.PROVIDER", LOG, new Object[0]).toString());
            this.ref = null;
            try {
                ((JBITransportFactory)((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi")).setDeliveryChannel(ctx.getDeliveryChannel());
                this.ref = ctx.activateEndpoint(this.getServiceName(), this.getEndpointName());
            }
            catch (JBIException e) {
                LOG.severe(new Message("SU.FAILED.ACTIVATE.ENDPOINT", LOG, new Object[0]).toString() + (Object)((Object)e));
            }
            catch (BusException e) {
                LOG.severe(new Message("SU.FAILED.ACTIVATE.ENDPOINT", LOG, new Object[0]).toString() + (Object)((Object)e));
            }
            LOG.info("activated endpoint: " + this.ref.getEndpointName() + " service: " + this.ref.getServiceName());
            serviceUnitManager.putServiceEndpoint(this.ref, this);
        } else {
            LOG.info(new Message("SU.START.CONSUMER", LOG, new Object[0]).toString());
            try {
                ((JBITransportFactory)((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi")).setDeliveryChannel(ctx.getDeliveryChannel());
            }
            catch (BusException e) {
                e.printStackTrace();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            new Thread(this.serviceConsumer).start();
        }
    }

    public QName getServiceName() {
        QName ret = null;
        if (this.isServiceProvider()) {
            if (this.serviceName == null) {
                WebService ws = this.serviceImplementation.getClass().getAnnotation(WebService.class);
                this.serviceName = new QName(ws.targetNamespace(), ws.serviceName());
            }
            ret = this.serviceName;
        } else {
            WebServiceClassFinder finder = new WebServiceClassFinder(this.rootPath, this.parentLoader);
            Collection<Class<?>> classes = null;
            try {
                classes = finder.findWebServiceInterface();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (classes.size() > 0) {
                Class<?> clz = classes.iterator().next();
                WebService ws = clz.getAnnotation(WebService.class);
                ret = this.serviceName = new QName(ws.targetNamespace(), ws.serviceName());
            }
        }
        return ret;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void prepare(ComponentContext ctx) throws ClassNotFoundException {
        try {
            WebServiceClassFinder finder = new WebServiceClassFinder(this.rootPath, this.parentLoader);
            Collection<Class<?>> classes = finder.findWebServiceClasses();
            if (classes.size() > 0) {
                LOG.info(new Message("SU.PUBLISH.ENDPOINT", LOG, new Object[0]).toString());
                this.isProvider = true;
                Class<?> clz = classes.iterator().next();
                this.serviceImplementation = clz.newInstance();
                if (EndpointUtils.isValidImplementor((Object)this.serviceImplementation)) {
                    this.createProviderConfiguration();
                    this.endpoint = new EndpointImpl(this.bus, this.serviceImplementation, "null");
                    this.endpoint.publish("http://foo/bar/baz");
                }
            } else {
                this.createConsumerConfiguration();
                classes = finder.findServiceConsumerClasses();
                Class<?> clz = classes.iterator().next();
                this.serviceConsumer = (ServiceConsumer)clz.newInstance();
                this.serviceConsumer.setComponentContext(ctx);
            }
        }
        catch (Exception ex) {
            if (ex.getCause() != null) {
                ex = (Exception)ex.getCause();
            }
            LOG.log(Level.SEVERE, new Message("SU.FAILED.PUBLISH.ENDPOINT", LOG, new Object[0]).toString(), ex);
        }
    }

    public ClassLoader getClassLoader() {
        return this.parentLoader;
    }

    Document getWsdlAsDocument() {
        Document doc = null;
        try {
            WebService ws = null;
            WebServiceClassFinder finder = new WebServiceClassFinder(this.rootPath, this.parentLoader);
            Collection<Class<?>> classes = finder.findWebServiceInterface();
            if (classes.size() > 0) {
                Class<?> clz = classes.iterator().next();
                ws = clz.getAnnotation(WebService.class);
            }
            if (ws != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(ws.wsdlLocation());
            } else {
                LOG.severe(new Message("SU.COULDNOT.GET.ANNOTATION", LOG, new Object[0]).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    private void parseJbiDescriptor() {
        File metaInf = new File(this.rootPath, "META-INF");
        File jbiXml = new File(metaInf, "jbi.xml");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(jbiXml.toURI().toURL().toString());
            Element providesEl = (Element)this.findNode(doc.getDocumentElement(), "provides");
            Element consumersEl = (Element)this.findNode(doc.getDocumentElement(), "consumes");
            if (providesEl != null) {
                this.endpointName = providesEl.getAttribute("endpoint-name");
            } else if (consumersEl != null) {
                this.endpointName = consumersEl.getAttribute("endpoint-name");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "error parsing " + jbiXml, ex);
        }
    }

    private Node findNode(Node root, String name) {
        if (name.equals(root.getNodeName())) {
            return root;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node found = this.findNode(node, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void createProviderConfiguration() {
    }

    private void createConsumerConfiguration() {
    }
}

