/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.javascript.JavascriptUtils;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.ParticleInfo;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJavascriptBuilder
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceJavascriptBuilder.class);
    private SoapBindingInfo soapBindingInfo;
    private JavascriptUtils utils;
    private NameManager nameManager;
    private StringBuilder code;
    private String currentInterfaceClassName;
    private OperationInfo currentOperation;
    private Set<OperationInfo> operationsWithNameConflicts;
    private Set<MessageInfo> inputMessagesWithNameConflicts;
    private Set<MessageInfo> outputMessagesWithNameConflicts;
    private SchemaCollection xmlSchemaCollection;
    private String endpointAddress;
    private boolean isWrapped;
    private MessagePartInfo inputWrapperPartInfo;
    private String inputWrapperClassName;
    private XmlSchemaElement inputWrapperElement;
    private XmlSchemaComplexType inputWrapperComplexType;
    private MessagePartInfo outputWrapperPartInfo;
    private XmlSchemaElement outputWrapperElement;
    private XmlSchemaComplexType outputWrapperComplexType;
    private List<String> inputParameterNames = new ArrayList<String>();
    private List<ParticleInfo> unwrappedElementsAndNames;
    private NamespacePrefixAccumulator prefixAccumulator;
    private BindingInfo xmlBindingInfo;
    private Map<String, OperationInfo> localOperationsNameMap;
    private Map<String, MessageInfo> localInputMessagesNameMap;
    private Map<String, MessageInfo> localOutputMessagesNameMap;
    private String opFunctionPropertyName;
    private String opFunctionGlobalName;
    private boolean isInUnwrappedOperation;
    private boolean nonVoidOutput;
    private boolean isRPC;

    public ServiceJavascriptBuilder(ServiceInfo serviceInfo, String endpointAddress, NamespacePrefixAccumulator prefixAccumulator, NameManager nameManager) {
        super(serviceInfo);
        this.endpointAddress = endpointAddress;
        this.code = new StringBuilder();
        this.utils = new JavascriptUtils(this.code);
        this.nameManager = nameManager;
        this.xmlSchemaCollection = serviceInfo.getXmlSchemaCollection();
        this.prefixAccumulator = prefixAccumulator;
    }

    public String getCode() {
        return this.code.toString();
    }

    public void begin(FaultInfo fault) {
    }

    public void begin(InterfaceInfo intf) {
        this.code.append("\n// Javascript for " + intf.getName() + "\n\n");
        this.currentInterfaceClassName = this.nameManager.getJavascriptName(intf.getName());
        this.operationsWithNameConflicts = new HashSet<OperationInfo>();
        this.inputMessagesWithNameConflicts = new HashSet<MessageInfo>();
        this.outputMessagesWithNameConflicts = new HashSet<MessageInfo>();
        this.localOperationsNameMap = new HashMap<String, OperationInfo>();
        this.localInputMessagesNameMap = new HashMap<String, MessageInfo>();
        this.localOutputMessagesNameMap = new HashMap<String, MessageInfo>();
        this.code.append("function " + this.currentInterfaceClassName + " () {\n");
        this.utils.appendLine("this.jsutils = new CxfApacheOrgUtil();");
        this.utils.appendLine("this.jsutils.interfaceObject = this;");
        this.utils.appendLine("this.synchronous = false;");
        if (this.endpointAddress != null) {
            this.utils.appendLine("this.url = '" + this.endpointAddress + "';");
        } else {
            this.utils.appendLine("this.url = null;");
        }
        this.utils.appendLine("this.client = null;");
        this.utils.appendLine("this.response = null;");
        this.generateGlobalElementDictionary();
        this.code.append("}\n\n");
    }

    private void generateGlobalElementDictionary() {
        this.utils.appendLine("this.globalElementSerializers = [];");
        this.utils.appendLine("this.globalElementDeserializers = [];");
        for (XmlSchema schemaInfo : this.xmlSchemaCollection.getXmlSchemas()) {
            QName name;
            XmlSchemaObjectTable globalElements = schemaInfo.getElements();
            Iterator namesIterator = globalElements.getNames();
            while (namesIterator.hasNext()) {
                name = (QName)namesIterator.next();
                XmlSchemaElement element = (XmlSchemaElement)globalElements.getItem(name);
                if (JavascriptUtils.notVeryComplexType(element.getSchemaType())) continue;
                XmlSchemaComplexType elementType = (XmlSchemaComplexType)element.getSchemaType();
                if (elementType != null && elementType.getQName() != null) {
                    name = elementType.getQName();
                }
                this.utils.appendLine("this.globalElementSerializers['" + name.toString() + "'] = " + this.nameManager.getJavascriptName(name) + "_serialize;");
                this.utils.appendLine("this.globalElementDeserializers['" + name.toString() + "'] = " + this.nameManager.getJavascriptName(name) + "_deserialize;");
            }
            globalElements = schemaInfo.getSchemaTypes();
            namesIterator = globalElements.getNames();
            while (namesIterator.hasNext()) {
                name = (QName)namesIterator.next();
                XmlSchemaType type = (XmlSchemaType)globalElements.getItem(name);
                if (JavascriptUtils.notVeryComplexType(type)) continue;
                this.utils.appendLine("this.globalElementSerializers['" + name.toString() + "'] = " + this.nameManager.getJavascriptName(name) + "_serialize;");
                this.utils.appendLine("this.globalElementDeserializers['" + name.toString() + "'] = " + this.nameManager.getJavascriptName(name) + "_deserialize;");
            }
        }
    }

    private String getFunctionGlobalName(QName itemName, String itemType) {
        return this.nameManager.getJavascriptName(itemName) + "_" + itemType;
    }

    private <T> String getFunctionPropertyName(Set<T> conflictMap, T object, QName fullName) {
        boolean needsLongName = conflictMap.contains(object);
        String functionName = needsLongName ? this.nameManager.getJavascriptName(fullName) : JavascriptUtils.javaScriptNameToken(fullName.getLocalPart());
        return functionName;
    }

    public void end(OperationInfo op) {
        if (op.isUnwrapped()) {
            this.isInUnwrappedOperation = false;
            return;
        }
        this.isWrapped = op.isUnwrappedCapable();
        StringBuilder parameterList = new StringBuilder();
        this.inputParameterNames = new ArrayList<String>();
        if (this.isWrapped) {
            this.collectWrapperElementInfo();
        } else {
            this.collectUnwrappedInputInfo();
        }
        this.buildParameterList(parameterList);
        MessageInfo outputMessage = op.getOutput();
        boolean bl = this.nonVoidOutput = outputMessage != null && outputMessage.getMessageParts().size() != 0;
        if (!op.isOneWay()) {
            this.buildSuccessFunction(outputMessage);
            this.buildErrorFunction();
        }
        this.buildOperationFunction(parameterList);
        this.createInputSerializer();
        if (this.nonVoidOutput) {
            this.createResponseDeserializer(outputMessage);
        }
    }

    private void collectUnwrappedInputInfo() {
        this.unwrappedElementsAndNames = new ArrayList<ParticleInfo>();
        if (this.currentOperation.getInput() != null) {
            this.getElementsForParts(this.currentOperation.getInput(), this.unwrappedElementsAndNames);
        }
        for (ParticleInfo ean : this.unwrappedElementsAndNames) {
            this.inputParameterNames.add(ean.getJavascriptName());
        }
    }

    private void buildOperationFunction(StringBuilder parameterList) {
        String syncAsyncFlag;
        String responseCallbackParams = "";
        if (!this.currentOperation.isOneWay()) {
            responseCallbackParams = "successCallback, errorCallback";
        }
        MessageInfo inputMessage = this.currentOperation.getInput();
        this.code.append("//\n");
        this.code.append("// Operation " + this.currentOperation.getName() + "\n");
        if (!this.isWrapped) {
            this.code.append("// - bare operation. Parameters:\n");
            for (ParticleInfo ei : this.unwrappedElementsAndNames) {
                this.code.append("// - " + this.getElementObjectName(ei) + "\n");
            }
        } else {
            this.code.append("// Wrapped operation.\n");
            QName contextQName = this.inputWrapperComplexType.getQName();
            if (contextQName == null) {
                contextQName = this.inputWrapperElement.getQName();
            }
            XmlSchemaSequence sequence = XmlSchemaUtils.getSequence((XmlSchemaComplexType)this.inputWrapperComplexType);
            XmlSchema wrapperSchema = this.xmlSchemaCollection.getSchemaByTargetNamespace(contextQName.getNamespaceURI());
            for (int i = 0; i < sequence.getItems().getCount(); ++i) {
                XmlSchemaType type;
                this.code.append("// parameter " + this.inputParameterNames.get(i) + "\n");
                XmlSchemaObject sequenceItem = sequence.getItems().getItem(i);
                ParticleInfo itemInfo = ParticleInfo.forLocalItem(sequenceItem, wrapperSchema, this.xmlSchemaCollection, this.prefixAccumulator, contextQName);
                if (itemInfo.isArray()) {
                    this.code.append("// - array\n");
                }
                if ((type = itemInfo.getType()) instanceof XmlSchemaComplexType) {
                    QName baseName = type.getQName() != null ? type.getQName() : ((XmlSchemaElement)sequenceItem).getQName();
                    this.code.append("// - Object constructor is " + this.nameManager.getJavascriptName(baseName) + "\n");
                    continue;
                }
                if (type == null) continue;
                this.code.append("// - simple type " + type.getQName());
            }
        }
        this.code.append("//\n");
        this.code.append("function " + this.opFunctionGlobalName + "(" + responseCallbackParams + (parameterList.length() > 0 && !this.currentOperation.isOneWay() ? ", " : "") + parameterList + ") {\n");
        this.utils.appendLine("this.client = new CxfApacheOrgClient(this.jsutils);");
        this.utils.appendLine("var xml = null;");
        if (inputMessage != null) {
            this.utils.appendLine("var args = new Array(" + this.inputParameterNames.size() + ");");
            int px = 0;
            for (String param : this.inputParameterNames) {
                this.utils.appendLine("args[" + px + "] = " + param + ";");
                ++px;
            }
            this.utils.appendLine("xml = this." + this.getFunctionPropertyName(this.inputMessagesWithNameConflicts, inputMessage, inputMessage.getName()) + "_serializeInput" + "(this.jsutils, args);");
        }
        if (!this.currentOperation.isOneWay()) {
            this.utils.appendLine("this.client.user_onsuccess = successCallback;");
            this.utils.appendLine("this.client.user_onerror = errorCallback;");
            this.utils.appendLine("var closureThis = this;");
            this.utils.appendLine("this.client.onsuccess = function(client, responseXml) { closureThis." + this.opFunctionPropertyName + "_onsuccess(client, responseXml); };");
            this.utils.appendLine("this.client.onerror = function(client) { closureThis." + this.opFunctionPropertyName + "_onerror(client); };");
        }
        this.utils.appendLine("var requestHeaders = [];");
        if (this.soapBindingInfo != null) {
            String action = this.soapBindingInfo.getSoapAction(this.currentOperation);
            this.utils.appendLine("requestHeaders['SOAPAction'] = '" + action + "';");
        }
        if (this.currentOperation.isOneWay()) {
            this.utils.appendLine("this.jsutils.trace('oneway operation');");
            syncAsyncFlag = "false";
        } else {
            this.utils.appendLine("this.jsutils.trace('synchronous = ' + this.synchronous);");
            syncAsyncFlag = "this.synchronous";
        }
        this.utils.appendLine("this.client.request(this.url, xml, null, " + syncAsyncFlag + ", requestHeaders);");
        this.code.append("}\n\n");
        this.code.append(this.currentInterfaceClassName + ".prototype." + this.opFunctionPropertyName + " = " + this.opFunctionGlobalName + ";\n\n");
    }

    private void buildErrorFunction() {
        String errorFunctionPropertyName = this.opFunctionPropertyName + "_onerror";
        String errorFunctionGlobalName = this.opFunctionGlobalName + "_onerror";
        this.code.append("function " + errorFunctionGlobalName + "(client) {\n");
        this.utils.startIf("client.user_onerror");
        this.utils.appendLine("var httpStatus;");
        this.utils.appendLine("var httpStatusText;");
        this.utils.appendLine("try {");
        this.utils.appendLine(" httpStatus = client.req.status;");
        this.utils.appendLine(" httpStatusText = client.req.statusText;");
        this.utils.appendLine("} catch(e) {");
        this.utils.appendLine(" httpStatus = -1;");
        this.utils.appendLine(" httpStatusText = 'Error opening connection to server';");
        this.utils.appendLine("}");
        this.utils.appendLine("client.user_onerror(httpStatus, httpStatusText);");
        this.utils.endBlock();
        this.code.append("}\n\n");
        this.code.append(this.currentInterfaceClassName + ".prototype." + errorFunctionPropertyName + " = " + errorFunctionGlobalName + ";\n\n");
    }

    private void buildSuccessFunction(MessageInfo outputMessage) {
        String successFunctionGlobalName = this.opFunctionGlobalName + "_onsuccess";
        String successFunctionPropertyName = this.opFunctionPropertyName + "_onsuccess";
        String arglist = "(client)";
        if (this.nonVoidOutput) {
            arglist = "(client, responseXml)";
        }
        this.code.append("function " + successFunctionGlobalName + arglist + " {\n");
        this.utils.startIf("client.user_onsuccess");
        this.utils.appendLine("var responseObject = null;");
        if (this.nonVoidOutput) {
            this.utils.appendLine("var element = responseXml.documentElement;");
            this.utils.appendLine("this.jsutils.trace('responseXml: ' + this.jsutils.traceElementName(element));");
            if (this.soapBindingInfo != null) {
                this.utils.appendLine("element = this.jsutils.getFirstElementChild(element);");
                this.utils.appendLine("this.jsutils.trace('first element child: ' + this.jsutils.traceElementName(element));");
                this.utils.appendLine("element = this.jsutils.getFirstElementChild(element);");
                this.utils.appendLine("this.jsutils.trace('part element: ' + this.jsutils.traceElementName(element));");
            }
            String deserializerFunctionName = this.outputDeserializerFunctionName(outputMessage);
            this.utils.appendLine("this.jsutils.trace('calling " + deserializerFunctionName + "');");
            this.utils.appendLine("responseObject = " + deserializerFunctionName + "(this.jsutils, element);");
        }
        this.utils.appendLine("client.user_onsuccess(responseObject);");
        this.utils.endBlock();
        this.code.append("}\n\n");
        this.code.append(this.currentInterfaceClassName + ".prototype." + successFunctionPropertyName + " = " + successFunctionGlobalName + ";\n\n");
    }

    private void buildParameterList(StringBuilder parameterList) {
        for (String param : this.inputParameterNames) {
            parameterList.append(param);
            parameterList.append(", ");
        }
        if (parameterList.length() > 2) {
            parameterList.setLength(parameterList.length() - 2);
        }
    }

    private String outputDeserializerFunctionName(MessageInfo message) {
        return this.getFunctionGlobalName(message.getName(), "deserializeResponse");
    }

    private void createResponseDeserializer(MessageInfo outputMessage) {
        List parts = outputMessage.getMessageParts();
        if (parts.size() != 1) {
            this.unsupportedConstruct("MULTIPLE_OUTPUTS", outputMessage.getName().toString());
        }
        ArrayList<ParticleInfo> elements = new ArrayList<ParticleInfo>();
        String functionName = this.outputDeserializerFunctionName(outputMessage);
        this.code.append("function " + functionName + "(cxfjsutils, partElement) {\n");
        this.getElementsForParts(outputMessage, elements);
        ParticleInfo element = (ParticleInfo)elements.get(0);
        XmlSchemaType type = null;
        if (this.isRPC) {
            this.utils.appendLine("cxfjsutils.trace('rpc element: ' + cxfjsutils.traceElementName(partElement));");
            this.utils.appendLine("partElement = cxfjsutils.getFirstElementChild(partElement);");
            this.utils.appendLine("cxfjsutils.trace('rpc element: ' + cxfjsutils.traceElementName(partElement));");
        }
        type = element.getType();
        if (!element.isEmpty()) {
            if (type instanceof XmlSchemaComplexType) {
                String typeObjectName = this.nameManager.getJavascriptName(element.getControllingName());
                this.utils.appendLine("var returnObject = " + typeObjectName + "_deserialize (cxfjsutils, partElement);\n");
            } else if (type instanceof XmlSchemaSimpleType) {
                XmlSchemaSimpleType simpleType = (XmlSchemaSimpleType)type;
                this.utils.appendLine("var returnText = cxfjsutils.getNodeText(partElement);");
                this.utils.appendLine("var returnObject = " + this.utils.javascriptParseExpression((XmlSchemaType)simpleType, "returnText") + ";");
            }
            this.utils.appendLine("return returnObject;");
        }
        this.code.append("}\n");
    }

    private String getElementObjectName(ParticleInfo element) {
        XmlSchemaType type = element.getType();
        if (!element.isEmpty()) {
            if (type instanceof XmlSchemaComplexType) {
                return this.nameManager.getJavascriptName(element.getControllingName());
            }
            return "type " + type.getQName();
        }
        return "empty element?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInputSerializer() {
        MessageInfo message = this.currentOperation.getInput();
        String serializerFunctionGlobalName = this.getFunctionGlobalName(message.getName(), "serializeInput");
        String serializerFunctionPropertyName = this.getFunctionPropertyName(this.inputMessagesWithNameConflicts, message, message.getName()) + "_serializeInput";
        this.code.append("function " + serializerFunctionGlobalName + "(cxfjsutils, args) {\n");
        String wrapperXmlElementName = null;
        if (this.isWrapped) {
            wrapperXmlElementName = this.prefixAccumulator.xmlElementString(this.inputWrapperPartInfo.getConcreteName());
            this.utils.appendLine("var wrapperObj = new " + this.inputWrapperClassName + "();");
            int px = 0;
            for (String param : this.inputParameterNames) {
                this.utils.appendLine("wrapperObj.set" + StringUtils.capitalize((String)param) + "(args[" + px + "]);");
                ++px;
            }
        }
        if (this.soapBindingInfo != null) {
            SoapVersion soapVersion = this.soapBindingInfo.getSoapVersion();
            assert (soapVersion.getVersion() == 1.1);
            this.utils.appendLine("var xml;");
            this.utils.appendLine("xml = cxfjsutils.beginSoap11Message(\"" + this.prefixAccumulator.getAttributes() + "\");");
        } else {
            this.unsupportedConstruct("XML_BINDING", this.currentInterfaceClassName, this.xmlBindingInfo.getName());
        }
        this.utils.setXmlStringAccumulator("xml");
        if (this.isWrapped) {
            ParticleInfo elementInfo = ParticleInfo.forPartElement(this.inputWrapperElement, this.xmlSchemaCollection, "wrapperObj", wrapperXmlElementName);
            elementInfo.setContainingType(null);
            this.utils.generateCodeToSerializeElement(elementInfo, "", this.xmlSchemaCollection);
        } else {
            String operationXmlElement = null;
            if (this.isRPC) {
                operationXmlElement = this.prefixAccumulator.xmlElementString(this.currentOperation.getName());
                this.utils.appendString("<" + operationXmlElement + ">");
            }
            int px = 0;
            for (ParticleInfo ean : this.unwrappedElementsAndNames) {
                String savedjsName = ean.getJavascriptName();
                try {
                    ean.setJavascriptName("args[" + px + "]");
                    this.utils.generateCodeToSerializeElement(ean, "", this.xmlSchemaCollection);
                    ++px;
                }
                finally {
                    ean.setJavascriptName(savedjsName);
                }
            }
            if (this.isRPC) {
                this.utils.appendString("</" + operationXmlElement + ">");
            }
        }
        this.utils.appendLine("xml = xml + cxfjsutils.endSoap11Message();");
        this.utils.appendLine("return xml;");
        this.code.append("}\n\n");
        this.code.append(this.currentInterfaceClassName + ".prototype." + serializerFunctionPropertyName + " = " + serializerFunctionGlobalName + ";\n\n");
    }

    private XmlSchemaSequence getTypeSequence(XmlSchemaComplexType type, QName parentName) {
        if (!(type.getParticle() instanceof XmlSchemaSequence)) {
            this.unsupportedConstruct("NON_SEQUENCE_PARTICLE", type.getQName() != null ? type.getQName() : parentName);
        }
        return (XmlSchemaSequence)type.getParticle();
    }

    private boolean isEmptyType(XmlSchemaType type, QName parentName) {
        if (type instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
            if (complexType.getParticle() == null) {
                return true;
            }
            XmlSchemaSequence sequence = this.getTypeSequence(complexType, parentName);
            if (sequence.getItems().getCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private XmlSchemaParticle getBuriedElement(XmlSchemaComplexType type, QName parentName) {
        XmlSchemaObject item;
        XmlSchemaSequence sequence = this.getTypeSequence(type, parentName);
        XmlSchemaObjectCollection insides = sequence.getItems();
        if (insides.getCount() == 1 && ((item = insides.getItem(0)) instanceof XmlSchemaElement || item instanceof XmlSchemaAny)) {
            return (XmlSchemaParticle)item;
        }
        return null;
    }

    private void getElementsForParts(MessageInfo message, List<ParticleInfo> elements) {
        for (MessagePartInfo mpi : message.getMessageParts()) {
            XmlSchemaParticle betterElement;
            boolean empty;
            XmlSchemaElement element = null;
            XmlSchemaType type = null;
            QName diagnosticName = mpi.getName();
            if (mpi.isElement()) {
                element = (XmlSchemaElement)mpi.getXmlSchema();
                if (element == null) {
                    element = XmlSchemaUtils.findElementByRefName((SchemaCollection)this.xmlSchemaCollection, (QName)mpi.getElementQName(), (String)this.serviceInfo.getTargetNamespace());
                }
                diagnosticName = element.getQName();
                type = element.getSchemaType();
                if (type == null) {
                    type = XmlSchemaUtils.getElementType((SchemaCollection)this.xmlSchemaCollection, null, (XmlSchemaElement)element, null);
                }
            } else {
                type = (XmlSchemaType)mpi.getXmlSchema();
                if (type == null) {
                    type = this.xmlSchemaCollection.getTypeByQName(mpi.getTypeQName());
                    diagnosticName = type.getQName();
                }
            }
            if (!(empty = this.isEmptyType(type, diagnosticName)) && type instanceof XmlSchemaComplexType && type.getName() == null && !this.isWrapped && (betterElement = this.getBuriedElement((XmlSchemaComplexType)type, diagnosticName)) instanceof XmlSchemaElement) {
                element = (XmlSchemaElement)betterElement;
                if (element.getSchemaType() == null) {
                    element.setSchemaType(this.xmlSchemaCollection.getTypeByQName(element.getSchemaTypeName()));
                }
                type = element.getSchemaType();
            }
            String partJavascriptVar = JavascriptUtils.javaScriptNameToken(mpi.getConcreteName().getLocalPart());
            String elementXmlRef = this.prefixAccumulator.xmlElementString(mpi.getConcreteName());
            ParticleInfo elementInfo = ParticleInfo.forPartElement(element, this.xmlSchemaCollection, partJavascriptVar, elementXmlRef);
            elementInfo.setType(type);
            elementInfo.setEmpty(empty);
            elements.add(elementInfo);
        }
    }

    private void collectWrapperElementInfo() {
        if (this.currentOperation.getInput() != null) {
            this.inputWrapperPartInfo = this.currentOperation.getInput().getMessagePart(0);
            List unwrappedParts = this.currentOperation.getUnwrappedOperation().getInput().getMessageParts();
            for (MessagePartInfo mpi : unwrappedParts) {
                String jsParamName = JavascriptUtils.javaScriptNameToken(mpi.getName().getLocalPart());
                this.inputParameterNames.add(jsParamName);
            }
            this.inputWrapperPartInfo = this.currentOperation.getInput().getMessagePart(0);
            assert (this.inputWrapperPartInfo.isElement());
            this.inputWrapperElement = (XmlSchemaElement)this.inputWrapperPartInfo.getXmlSchema();
            if (this.inputWrapperElement == null) {
                this.inputWrapperElement = XmlSchemaUtils.findElementByRefName((SchemaCollection)this.xmlSchemaCollection, (QName)this.inputWrapperPartInfo.getElementQName(), (String)this.serviceInfo.getTargetNamespace());
            }
            this.inputWrapperComplexType = (XmlSchemaComplexType)this.inputWrapperElement.getSchemaType();
            if (this.inputWrapperComplexType == null) {
                this.inputWrapperComplexType = (XmlSchemaComplexType)XmlSchemaUtils.getElementType((SchemaCollection)this.xmlSchemaCollection, (String)this.serviceInfo.getTargetNamespace(), (XmlSchemaElement)this.inputWrapperElement, null);
            }
            if (this.inputWrapperComplexType == null) {
                this.unsupportedConstruct("MISSING_WRAPPER_TYPE", this.currentOperation.getInterface().getName(), this.currentOperation.getName(), this.inputWrapperPartInfo.getName());
            }
            if (this.inputWrapperComplexType.getQName() == null) {
                if (this.inputWrapperPartInfo.isElement()) {
                    this.inputWrapperClassName = this.nameManager.getJavascriptName(this.inputWrapperPartInfo.getElementQName());
                } else {
                    this.unsupportedConstruct("NON_ELEMENT_ANON_TYPE_PART", this.inputWrapperPartInfo.getMessageInfo().getName(), this.inputWrapperPartInfo.getName());
                }
            } else {
                this.inputWrapperClassName = this.nameManager.getJavascriptName(this.inputWrapperComplexType.getQName());
            }
        }
        if (this.currentOperation.getOutput() != null) {
            this.outputWrapperPartInfo = this.currentOperation.getOutput().getMessagePart(0);
            assert (this.outputWrapperPartInfo.isElement());
            this.outputWrapperElement = (XmlSchemaElement)this.outputWrapperPartInfo.getXmlSchema();
            if (this.outputWrapperElement == null) {
                this.outputWrapperElement = XmlSchemaUtils.findElementByRefName((SchemaCollection)this.xmlSchemaCollection, (QName)this.outputWrapperPartInfo.getElementQName(), (String)this.serviceInfo.getTargetNamespace());
            }
            this.outputWrapperComplexType = (XmlSchemaComplexType)this.outputWrapperElement.getSchemaType();
            if (this.outputWrapperComplexType == null) {
                this.outputWrapperComplexType = (XmlSchemaComplexType)XmlSchemaUtils.getElementType((SchemaCollection)this.xmlSchemaCollection, (String)this.serviceInfo.getTargetNamespace(), (XmlSchemaElement)this.outputWrapperElement, null);
            }
        }
    }

    public void begin(ServiceInfo service) {
        this.code.append("//\n");
        this.code.append("// Definitions for service: " + service.getName().toString() + "\n");
        this.code.append("//\n");
        BindingInfo xml = null;
        for (BindingInfo bindingInfo : service.getBindings()) {
            if ("http://schemas.xmlsoap.org/soap/".equals(bindingInfo.getBindingId()) || "http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingInfo.getBindingId()) || "http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingInfo.getBindingId()) || "http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingInfo.getBindingId())) {
                SoapBindingInfo sbi = (SoapBindingInfo)bindingInfo;
                if (!"http://schemas.xmlsoap.org/soap/http".equals(sbi.getTransportURI()) && !"http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(sbi.getTransportURI()) && !"http://cxf.apache.org/transports/local".equals(sbi.getTransportURI())) continue;
                this.soapBindingInfo = sbi;
                break;
            }
            if (!"http://cxf.apache.org/bindings/xformat".equals(bindingInfo.getBindingId())) continue;
            xml = bindingInfo;
        }
        if (this.soapBindingInfo == null && xml == null) {
            this.unsupportedConstruct("NO_USABLE_BINDING", service.getName());
        }
        if (this.soapBindingInfo != null) {
            this.isRPC = this.soapBindingInfo.getStyle().equals("rpc");
        } else if (xml != null) {
            this.xmlBindingInfo = xml;
        }
    }

    public void end(FaultInfo fault) {
    }

    public void end(InterfaceInfo intf) {
    }

    public void end(MessageInfo msg) {
    }

    public void end(MessagePartInfo part) {
    }

    public void end(ServiceInfo service) {
        LOG.finer(this.getCode());
    }

    private void unsupportedConstruct(String messageKey, Object ... args) {
        Message message = new Message(messageKey, LOG, args);
        throw new UnsupportedConstruct(message);
    }

    public void begin(OperationInfo op) {
        if (op.isUnwrapped()) {
            this.isInUnwrappedOperation = true;
            return;
        }
        this.currentOperation = op;
        OperationInfo conflict = this.localOperationsNameMap.get(op.getName().getLocalPart());
        if (conflict != null) {
            this.operationsWithNameConflicts.add(conflict);
            this.operationsWithNameConflicts.add(op);
        }
        this.localOperationsNameMap.put(op.getName().getLocalPart(), op);
        this.opFunctionPropertyName = this.getFunctionPropertyName(this.operationsWithNameConflicts, op, op.getName());
        this.opFunctionGlobalName = this.getFunctionGlobalName(op.getName(), "op");
    }

    public void begin(MessageInfo msg) {
        Set<MessageInfo> conflicts;
        Map<String, MessageInfo> nameMap;
        if (this.isInUnwrappedOperation) {
            return;
        }
        LOG.fine("Message " + msg.getName().toString());
        if (msg.getType() == MessageInfo.Type.INPUT) {
            nameMap = this.localInputMessagesNameMap;
            conflicts = this.inputMessagesWithNameConflicts;
        } else {
            nameMap = this.localOutputMessagesNameMap;
            conflicts = this.outputMessagesWithNameConflicts;
        }
        MessageInfo conflict = nameMap.get(msg.getName().getLocalPart());
        if (conflict != null) {
            conflicts.add(conflict);
            conflicts.add(msg);
        }
        nameMap.put(msg.getName().getLocalPart(), msg);
    }

    public void begin(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        String portClassName = this.currentInterfaceClassName + "_" + this.nameManager.getJavascriptName(endpointInfo.getName());
        this.code.append("function " + portClassName + " () {\n");
        this.code.append("  this.url = '" + address + "';\n");
        this.code.append("}\n");
        this.code.append(portClassName + ".prototype = new " + this.currentInterfaceClassName + ";\n");
    }
}

