/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.idlpreprocessor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.cxf.tools.corba.idlpreprocessor.IncludeResolver;
import org.apache.cxf.tools.corba.idlpreprocessor.PreprocessingException;

public class DefaultIncludeResolver
implements IncludeResolver {
    private final File[] userIdlDirs;

    public DefaultIncludeResolver(File ... idlDirs) {
        for (File dir : idlDirs) {
            if (dir.isDirectory()) continue;
            throw new IllegalArgumentException("not a directory: " + dir.getAbsoluteFile());
        }
        this.userIdlDirs = idlDirs;
    }

    public URL findSystemInclude(String spec) {
        return this.findUserInclude(spec);
    }

    public URL findUserInclude(String spec) {
        int i$ = 0;
        File[] arr$ = this.userIdlDirs;
        int len$ = arr$.length;
        if (i$ < len$) {
            File searchDir = arr$[i$];
            URI searchDirURI = searchDir.toURI();
            try {
                URL searchDirURL = searchDirURI.toURL();
                URL url = new URL(searchDirURL, spec);
                return url;
            }
            catch (MalformedURLException e) {
                PreprocessingException preprocessingException = new PreprocessingException("Unable to resolve user include '" + spec + "' in '" + this.userIdlDirs + "'", null, 0);
                preprocessingException.initCause(e);
                throw preprocessingException;
            }
        }
        throw new PreprocessingException("unable to resolve " + spec, null, 0);
    }
}

