/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;

public class ClientPolicyInFaultInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientPolicyInFaultInterceptor.class);

    public ClientPolicyInFaultInterceptor() {
        super("org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor", "receive");
    }

    protected void handle(Message msg) {
        if (!MessageUtils.isRequestor(msg)) {
            LOG.fine("Not a requestor.");
            return;
        }
        Exchange exchange = msg.getExchange();
        assert (null != exchange);
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Conduit conduit = exchange.getConduit(msg);
        LOG.fine("conduit: " + conduit);
        EndpointPolicy ep = pe.getClientEndpointPolicy(ei, conduit);
        LOG.fine("ep: " + ep);
        List<Interceptor> faultInterceptors = ep.getFaultInterceptors();
        LOG.fine("faultInterceptors: " + faultInterceptors);
        for (Interceptor i : faultInterceptors) {
            msg.getInterceptorChain().add(i);
            LOG.log(Level.INFO, "Added interceptor of type {0}", i.getClass().getSimpleName());
        }
        Collection<PolicyAssertion> assertions = ep.getFaultVocabulary();
        if (null != assertions) {
            msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
        }
    }
}

