/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.builder.xml.XmlPrimitiveAssertion;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsTokenBuilder
implements AssertionBuilder {
    PolicyBuilder builder;

    public HttpsTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public PolicyAssertion build(Element element) {
        HttpsToken httpsToken = new HttpsToken(SP12Constants.INSTANCE);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), httpsToken);
        }
        return httpsToken;
    }

    public List<QName> getKnownElements() {
        return Collections.singletonList(SP12Constants.HTTPS_TOKEN);
    }

    private void processAlternative(List assertions, HttpsToken parent) {
        for (XmlPrimitiveAssertion primtive : assertions) {
            QName qname = primtive.getName();
            if (qname == null) continue;
            if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(qname)) {
                parent.setHttpBasicAuthentication(true);
                continue;
            }
            if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(qname)) {
                parent.setHttpDigestAuthentication(true);
                continue;
            }
            if (!SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(qname)) continue;
            parent.setRequireClientCertificate(true);
        }
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

