/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;

public class SybaseMaxValueIncrementer
extends AbstractColumnMaxValueIncrementer {
    private long[] valueCache;
    private int nextValueIndex = -1;

    public SybaseMaxValueIncrementer() {
    }

    public SybaseMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnName) {
        super(dataSource, incrementerName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.nextValueIndex < 0 || this.nextValueIndex >= this.getCacheSize()) {
            Connection con = DataSourceUtils.getConnection(this.getDataSource());
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                this.valueCache = new long[this.getCacheSize()];
                this.nextValueIndex = 0;
                for (int i = 0; i < this.getCacheSize(); ++i) {
                    stmt.executeUpdate("insert into " + this.getIncrementerName() + " values()");
                    ResultSet rs = stmt.executeQuery("select @@identity");
                    try {
                        if (!rs.next()) {
                            throw new DataAccessResourceFailureException("@@identity failed after executing an update");
                        }
                        this.valueCache[i] = rs.getLong(1);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeResultSet(rs);
                    }
                }
                long maxValue = this.valueCache[this.valueCache.length - 1];
                stmt.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.getColumnName() + " < " + maxValue);
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not increment identity", ex);
            }
            finally {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
            }
        }
        return this.valueCache[this.nextValueIndex++];
    }
}

