/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.List;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;
import org.apache.cxf.tools.corba.common.idltypes.IdlUnionBranch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdlUnion
extends IdlScopeBase
implements IdlType {
    private IdlType discriminator;

    private IdlUnion(IdlScopeBase parent, String name, IdlType disc) {
        super(parent, name);
        this.discriminator = disc;
    }

    public static IdlUnion create(IdlScopeBase parent, String name, IdlType discriminator) {
        return new IdlUnion(parent, name, discriminator);
    }

    public void addBranch(IdlUnionBranch ub) {
        this.addToScope(ub);
    }

    @Override
    public void write(PrintWriter pw) {
        pw.println(IdlUnion.indent() + "union " + this.localName() + " switch(" + this.discriminator.fullName(this.scopeName()) + ") {");
        IdlUnion.indentMore();
        super.write(pw);
        IdlUnion.indentLess();
        pw.println(IdlUnion.indent() + "};");
    }

    @Override
    public void writeFwd(PrintWriter pw) {
        if (this.isCircular()) {
            pw.println(IdlUnion.indent() + "union " + this.localName() + ";");
        }
    }

    @Override
    public IdlScopeBase getCircularScope(IdlScopeBase startScope, List<Object> doneDefn) {
        if (startScope == null) {
            startScope = this;
        }
        return super.getCircularScope(startScope, doneDefn);
    }
}

