/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAAJInInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SAAJInInterceptor.class);

    public SAAJInInterceptor() {
        super("pre-protocol");
    }

    public SAAJInInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        try {
            XMLStreamReader xmlReader;
            MessageFactory factory = null;
            factory = message.getVersion() instanceof Soap11 ? MessageFactory.newInstance() : MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            SOAPMessage soapMessage = factory.createMessage();
            message.setContent(SOAPMessage.class, soapMessage);
            SOAPPart part = soapMessage.getSOAPPart();
            Document node = (Document)message.getContent(Node.class);
            DOMSource source = new DOMSource(node);
            part.setContent((Source)source);
            Collection<Attachment> atts = message.getAttachments();
            if (atts != null) {
                for (Attachment a : atts) {
                    AttachmentPart ap = soapMessage.createAttachmentPart(a.getDataHandler());
                    soapMessage.addAttachmentPart(ap);
                }
            }
            if (message.hasHeaders()) {
                SAAJInInterceptor.replaceHeaders(soapMessage, message);
            }
            if (soapMessage.getSOAPHeader() == null) {
                soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            if (SAAJInInterceptor.hasFault(message, xmlReader = message.getContent(XMLStreamReader.class))) {
                SoapFault fault;
                SOAPFault soapFault = soapMessage.getSOAPPart().getEnvelope().getBody().addFault();
                SoapFault soapFault2 = fault = message.getVersion() instanceof Soap11 ? Soap11FaultInInterceptor.unmarshalFault(message, xmlReader) : Soap12FaultInInterceptor.unmarshalFault(message, xmlReader);
                if (fault.getFaultCode() != null) {
                    soapFault.setFaultCode(fault.getFaultCode());
                }
                if (fault.getMessage() != null) {
                    soapFault.setFaultString(fault.getMessage());
                }
                if (fault.getRole() != null) {
                    soapFault.setFaultActor(fault.getRole());
                }
                if (fault.getDetail() != null) {
                    soapFault.addDetail().appendChild(soapMessage.getSOAPPart().importNode(fault.getDetail().getFirstChild(), true));
                }
                DOMSource bodySource = new DOMSource((Node)soapFault);
                xmlReader = StaxUtils.createXMLStreamReader(bodySource);
            } else {
                StaxUtils.readDocElements((Node)soapMessage.getSOAPBody(), xmlReader, true);
                DOMSource bodySource = new DOMSource((Node)soapMessage.getSOAPPart().getEnvelope().getBody());
                xmlReader = StaxUtils.createXMLStreamReader(bodySource);
                xmlReader.nextTag();
                xmlReader.nextTag();
            }
            message.setContent(XMLStreamReader.class, xmlReader);
        }
        catch (SOAPException soape) {
            throw new SoapFault(new Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)soape, message.getVersion().getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
    }

    public static void replaceHeaders(SOAPMessage soapMessage, SoapMessage message) throws SOAPException {
        SOAPHeader header = soapMessage.getSOAPHeader();
        if (header == null) {
            return;
        }
        Element elem = DOMUtils.getFirstElement((Node)header);
        while (elem != null) {
            Bus b = message.getExchange().get(Bus.class);
            HeaderProcessor p = null;
            if (b != null && b.getExtension(HeaderManager.class) != null) {
                p = b.getExtension(HeaderManager.class).getHeaderProcessor(elem.getNamespaceURI());
            }
            DataBinding dataBinding = null;
            Object obj = p == null || p.getDataBinding() == null ? elem : p.getDataBinding().createReader(Node.class).read(elem);
            SoapHeader shead = new SoapHeader(new QName(elem.getNamespaceURI(), elem.getLocalName()), obj, dataBinding);
            shead.setDirection(Header.Direction.DIRECTION_IN);
            String mu = elem.getAttributeNS(message.getVersion().getNamespace(), message.getVersion().getAttrNameMustUnderstand());
            String act = elem.getAttributeNS(message.getVersion().getNamespace(), message.getVersion().getAttrNameRole());
            shead.setActor(act);
            shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
            Header oldHdr = message.getHeader(new QName(elem.getNamespaceURI(), elem.getLocalName()));
            if (oldHdr != null) {
                message.getHeaders().remove(oldHdr);
            }
            message.getHeaders().add(shead);
            elem = DOMUtils.getNextElement(elem);
        }
    }

    private static boolean hasFault(SoapMessage message, XMLStreamReader xmlReader) {
        try {
            QName name = xmlReader.getName();
            return message.getVersion().getFault().equals(name);
        }
        catch (Exception e) {
            return false;
        }
    }
}

