/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServerFactoryBean
extends AbstractEndpointFactory {
    protected boolean doInit;
    private Server server;
    private Invoker invoker;
    private boolean start = true;
    private JAXRSServiceFactoryBean serviceFactory;
    private List<Object> serviceBeans;
    private List<?> entityProviders;
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;
    private List<String> schemaLocations;

    public JAXRSServerFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
        this.serviceFactory = sf;
        this.doInit = true;
        this.setBindingId("http://apache.org/cxf/binding/jaxrs");
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public Server create() {
        try {
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
            if (this.invoker == null) {
                ep.getService().setInvoker(this.createInvoker());
            } else {
                ep.getService().setInvoker(this.invoker);
            }
            if (this.entityProviders != null) {
                ProviderFactory.getInstance(this.getAddress()).setUserProviders(this.entityProviders);
            }
            ProviderFactory.getInstance(this.getAddress()).setRequestPreprocessor(new RequestPreprocessor(this.languageMappings, this.extensionMappings));
            if (this.schemaLocations != null) {
                ProviderFactory.getInstance(this.getAddress()).setSchemaLocations(this.schemaLocations);
            }
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException(e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException(e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException(e);
        }
        this.applyFeatures();
        return this.server;
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected Invoker createInvoker() {
        if (this.serviceBeans == null) {
            return new JAXRSInvoker();
        }
        return new JAXRSInvoker(this.serviceBeans);
    }

    @Override
    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Service service = this.serviceFactory.getService();
        if (service == null) {
            service = this.serviceFactory.create();
        }
        EndpointInfo ei = this.createEndpointInfo();
        EndpointImpl ep = new EndpointImpl(this.getBus(), this.getServiceFactory().getService(), ei);
        if (this.properties != null) {
            ep.putAll(this.properties);
        }
        if (this.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        return ep;
    }

    @Override
    protected EndpointInfo createEndpointInfo() throws BusException {
        String transportId = this.getTransportId();
        if (transportId == null && this.getAddress() != null) {
            DestinationFactory df = this.getDestinationFactory();
            if (df == null) {
                DestinationFactoryManager dfm = this.getBus().getExtension(DestinationFactoryManager.class);
                df = dfm.getDestinationFactoryForUri(this.getAddress());
            }
            if (df != null) {
                transportId = df.getTransportIds().get(0);
            }
        }
        if (transportId == null) {
            transportId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        this.setTransportId(transportId);
        EndpointInfo ei = new EndpointInfo();
        ei.setTransportId(transportId);
        ei.setName(this.serviceFactory.getService().getName());
        ei.setAddress(this.getAddress());
        BindingInfo bindingInfo = this.createBindingInfo();
        ei.setBinding(bindingInfo);
        return ei;
    }

    @Override
    protected BindingInfo createBindingInfo() {
        BindingFactoryManager mgr = this.getBus().getExtension(BindingFactoryManager.class);
        String binding = this.getBindingId();
        BindingConfiguration bindingConfig = this.getBindingConfig();
        if (binding == null && bindingConfig != null) {
            binding = bindingConfig.getBindingId();
        }
        if (binding == null) {
            binding = "http://apache.org/cxf/binding/jaxrs";
        }
        try {
            BindingFactory bindingFactory = mgr.getBindingFactory(binding);
            this.setBindingFactory(bindingFactory);
            return bindingFactory.createBindingInfo(this.serviceFactory.getService(), binding, bindingConfig);
        }
        catch (BusException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setLanguageMappings(Map<Object, Object> lMaps) {
        this.languageMappings = lMaps;
    }

    public void setExtensionMappings(Map<Object, Object> extMaps) {
        this.extensionMappings = extMaps;
    }

    public JAXRSServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public List<Class> getResourceClasses() {
        return this.serviceFactory.getResourceClasses();
    }

    public void setResourceClasses(List<Class> classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setResourceClasses(Class ... classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setServiceBeans(Object ... beans) {
        this.setServiceBeans(Arrays.asList(beans));
    }

    public void setServiceBeans(List<Object> beans) {
        this.serviceBeans = beans;
        this.serviceFactory.setResourceClassesFromBeans(beans);
    }

    public void setResourceProvider(Class c, ResourceProvider rp) {
        this.serviceFactory.setResourceProvider(c, rp);
    }

    public List<?> getProviders() {
        return this.entityProviders;
    }

    public void setProviders(List<? extends Object> providers) {
        this.entityProviders = providers;
    }
}

