/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientProxy
extends ClientProxy
implements InvocationHandler,
BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    private final Binding binding;
    private final EndpointReferenceBuilder builder;

    public JaxWsClientProxy(Client c, Binding b) {
        super(c);
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)this.getClient().getEndpoint());
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BindingOperationInfo oi;
        Endpoint endpoint = this.getClient().getEndpoint();
        String address = endpoint.getEndpointInfo().getAddress();
        MethodDispatcher dispatcher = (MethodDispatcher)endpoint.getService().get(MethodDispatcher.class.getName());
        Object[] params = args;
        if (null == params) {
            params = new Object[]{};
        }
        if ((oi = dispatcher.getBindingOperation(method, endpoint)) == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(BindingProviderImpl.class) || method.getDeclaringClass().equals(Object.class)) {
                try {
                    return method.invoke((Object)this, params);
                }
                catch (InvocationTargetException e) {
                    throw e.fillInStackTrace().getCause();
                }
            }
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, method.getName());
            throw new WebServiceException(msg.toString());
        }
        this.client.getRequestContext().put(Method.class.getName(), method);
        boolean isAsync = method.getName().endsWith("Async");
        Object result = null;
        try {
            result = isAsync ? this.invokeAsync(method, oi, params) : this.invokeSync(method, oi, params);
        }
        catch (WebServiceException wex) {
            throw wex.fillInStackTrace();
        }
        catch (Exception ex) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex)) continue;
                throw ex.fillInStackTrace();
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = this.createSoapFault(ex);
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)ex);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
            }
        }
        Map<String, Object> respContext = this.client.getResponseContext();
        Map scopes = CastUtils.cast((Map)respContext.get(WrappedMessageContext.SCOPES));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                respContext.remove(scope.getKey());
            }
        }
        return result;
    }

    private SOAPFault createSoapFault(Exception ex) throws SOAPException {
        SOAPFault soapFault;
        try {
            soapFault = ((SOAPBinding)this.getBinding()).getSOAPFactory().createFault();
        }
        catch (Throwable t) {
            try {
                soapFault = ((SOAPBinding)this.getBinding()).getMessageFactory().createMessage().getSOAPBody().addFault();
            }
            catch (Throwable t2) {
                return null;
            }
        }
        if (ex instanceof SoapFault) {
            soapFault.setFaultString(((SoapFault)ex).getReason());
            soapFault.setFaultCode(((SoapFault)ex).getFaultCode());
            soapFault.setFaultActor(((SoapFault)ex).getRole());
            Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex).getOrCreateDetail(), true);
            nd = nd.getFirstChild();
            soapFault.addDetail();
            while (nd != null) {
                Node next = nd.getNextSibling();
                soapFault.getDetail().appendChild(nd);
                nd = next;
            }
        } else {
            try {
                soapFault.setFaultCode(new QName("http://cxf.apache.org/faultcode", "HandlerFault"));
            }
            catch (SOAPException ex2) {
                // empty catch block
            }
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    private boolean addressChanged(String address) {
        return address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params) throws Exception {
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        final AsyncHandler handler = params.length > 0 && params[params.length - 1] instanceof AsyncHandler ? (AsyncHandler)params[params.length - 1] : null;
        ClientCallback callback = new ClientCallback(){
            boolean handlerCalled;

            @Override
            public void handleResponse(Map<String, Object> ctx, Object[] res) {
                super.handleResponse(ctx, res);
                if (handler != null) {
                    handler.handleResponse((Response)new ResponseCallback(this));
                }
                this.handlerCalled = true;
            }

            @Override
            public boolean isDone() {
                return this.handlerCalled && super.isDone();
            }
        };
        ResponseCallback ret = new ResponseCallback(callback);
        this.client.invoke(callback, oi, params);
        return ret;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.getClient().getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    @Override
    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.getClient().getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return this.builder.getEndpointReference(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResponseCallback
    implements Response<Object> {
        ClientCallback callback;

        public ResponseCallback(ClientCallback cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.callback.get()[0];
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.callback.get(timeout, unit)[0];
        }

        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        public boolean isDone() {
            return this.callback.isDone();
        }
    }
}

