/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionFactoryImpl;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
WSDLEndpointFactory {
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    protected Bus bus;
    protected Collection<String> activationNamespaces;

    @Resource(name="cxf")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    public void registerWithBindingManager() {
        if (null == this.bus) {
            return;
        }
        if (this.getTransportIds() == null) {
            this.setTransportIds(new ArrayList<String>(this.activationNamespaces));
        } else if (this.activationNamespaces == null) {
            this.activationNamespaces = this.getTransportIds();
        }
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)this);
            }
        }
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget());
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        HTTPConduit conduit = target == null ? new HTTPConduit(this.bus, endpointInfo) : new HTTPConduit(this.bus, endpointInfo, target);
        String address = conduit.getAddress();
        if (address != null && address.indexOf(63) != -1) {
            address = address.substring(0, address.indexOf(63));
        }
        this.configure((Object)conduit, conduit.getBeanName(), address);
        conduit.finalizeConfig();
        return conduit;
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (extensor instanceof HTTPAddress) {
                    HTTPAddress httpAdd = (HTTPAddress)extensor;
                    HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                    info.setAddress(httpAdd.getLocationURI());
                    info.addExtensor(httpAdd);
                    return info;
                }
                if (!(extensor instanceof AddressType)) continue;
                AddressType httpAdd = (AddressType)extensor;
                HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                info.setAddress(httpAdd.getLocation());
                info.addExtensor(httpAdd);
                return info;
            }
        }
        HttpEndpointInfo hei = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
        HttpAddressType at = new HttpAddressType();
        hei.addExtensor((Object)at);
        return hei;
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Object bean) {
        this.configure(bean, null, null);
    }

    protected void configure(Object bean, String name, String extraName) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, bean);
            if (extraName != null) {
                configurer.configureBean(extraName, bean);
            }
        }
    }

    static HttpURLConnectionFactory getConnectionFactory(HTTPConduit configuredConduit) {
        return AbstractHTTPTransportFactory.getConnectionFactory(configuredConduit, null);
    }

    static HttpURLConnectionFactory getConnectionFactory(HTTPConduit configuredConduit, String address) {
        HttpURLConnectionFactory fac = null;
        boolean useHttps = false;
        try {
            if (address == null) {
                address = configuredConduit.getAddress();
            }
            if (address != null && address.startsWith("https:/")) {
                useHttps = true;
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (useHttps) {
            TLSClientParameters params = configuredConduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
            }
            fac = new HttpsURLConnectionFactory(params);
        } else {
            fac = new HttpURLConnectionFactoryImpl();
        }
        return fac;
    }

    static {
        URI_PREFIXES.add("http://");
        URI_PREFIXES.add("https://");
    }

    private static class HttpAddressType
    extends AddressType
    implements HTTPAddress,
    SOAPAddress {
        public HttpAddressType() {
            this.setElementType(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
        }

        public String getLocationURI() {
            return this.getLocation();
        }

        public void setLocationURI(String locationURI) {
            this.setLocation(locationURI);
        }
    }

    private static class HttpEndpointInfo
    extends EndpointInfo {
        AddressType saddress;

        HttpEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocation(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof AddressType) {
                this.saddress = (AddressType)el;
            }
        }
    }
}

