/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xmlbeans;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.xmlbeans.DataReaderImpl;
import org.apache.cxf.xmlbeans.DataWriterImpl;
import org.apache.cxf.xmlbeans.NodeDataWriterImpl;
import org.apache.cxf.xmlbeans.XmlBeansSchemaInitializer;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeansDataBinding
extends AbstractDataBinding {
    private static final Logger LOG = LogUtils.getLogger(XmlBeansDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{XMLStreamWriter.class, Node.class};

    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (c == XMLStreamWriter.class) {
            return new DataWriterImpl();
        }
        if (c == Node.class) {
            return new NodeDataWriterImpl();
        }
        return null;
    }

    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl();
        }
        return dr;
    }

    public Map<String, String> getDeclaredNamespaceMappings() {
        return null;
    }

    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    public void initialize(Service service) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Creating XmlBeansDatabinding for " + service.getName());
        }
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) continue;
            XmlBeansSchemaInitializer schemaInit = new XmlBeansSchemaInitializer(serviceInfo, col, this);
            schemaInit.walk();
        }
    }
}

