/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSServiceFactoryBean
extends AbstractServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSServiceFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSServiceFactoryBean.class);
    protected List<ClassResourceInfo> classResourceInfos = new ArrayList<ClassResourceInfo>();
    protected Map<Class, ResourceProvider> resourceProviders = new HashMap<Class, ResourceProvider>();
    private Invoker invoker;
    private Executor executor;
    private Map<String, Object> properties;

    public Service create() {
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        return this.getService();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public List<Class> getResourceClasses() {
        ArrayList<Class> resourceClasses = new ArrayList<Class>();
        for (ClassResourceInfo cri : this.classResourceInfos) {
            resourceClasses.add(cri.getResourceClass());
        }
        return resourceClasses;
    }

    public List<ClassResourceInfo> getClassResourceInfo() {
        return Collections.unmodifiableList(this.classResourceInfos);
    }

    public void setResourceClasses(List<Class> classes) {
        for (Class resourceClass : classes) {
            ClassResourceInfo classResourceInfo = this.createClassResourceInfo(resourceClass, resourceClass, true);
            if (classResourceInfo == null) continue;
            this.classResourceInfos.add(classResourceInfo);
        }
        this.injectContexts();
    }

    public void setResourceClasses(Class ... classes) {
        this.setResourceClasses(Arrays.asList(classes));
    }

    public void setResourceClassesFromBeans(List<Object> beans) {
        for (Object bean : beans) {
            Class realClass = ClassHelper.getRealClass((Object)bean);
            ClassResourceInfo classResourceInfo = this.createClassResourceInfo(bean.getClass(), realClass, true);
            if (classResourceInfo == null) continue;
            this.classResourceInfos.add(classResourceInfo);
            classResourceInfo.setResourceProvider(new SingletonResourceProvider(bean));
        }
    }

    private void injectContexts() {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (!cri.isSingleton()) continue;
            InjectionUtils.injectContextProxies(cri, cri.getResourceProvider().getInstance());
        }
    }

    public void setResourceProvider(Class c, ResourceProvider rp) {
        this.resourceProviders.put(c, rp);
    }

    protected void initializeServiceModel() {
        this.updateClassResourceProviders();
        JAXRSServiceImpl service = new JAXRSServiceImpl(this.classResourceInfos);
        this.setService(service);
        if (this.properties != null) {
            service.putAll(this.properties);
        }
    }

    private void updateClassResourceProviders() {
        for (ClassResourceInfo cri : this.classResourceInfos) {
            if (cri.getResourceProvider() != null) continue;
            ResourceProvider rp = this.resourceProviders.get(cri.getResourceClass());
            if (rp != null) {
                cri.setResourceProvider(rp);
                continue;
            }
            rp = new PerRequestResourceProvider(cri.getResourceClass());
            cri.setResourceProvider(rp);
        }
        this.injectContexts();
    }

    protected ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root);
        if (root) {
            URITemplate t = URITemplate.createTemplate(cri, cri.getPath());
            cri.setURITemplate(t);
        }
        MethodDispatcher md = this.createOperation(cri);
        cri.setMethodDispatcher(md);
        return this.checkMethodDispatcher(cri) ? cri : null;
    }

    protected MethodDispatcher createOperation(ClassResourceInfo cri) {
        MethodDispatcher md = new MethodDispatcher();
        for (Method m : cri.getServiceClass().getMethods()) {
            Class<?> subResourceClass;
            ClassResourceInfo subCri;
            Method annotatedMethod = AnnotationUtils.getAnnotatedMethod(m);
            String httpMethod = AnnotationUtils.getHttpMethodValue(annotatedMethod);
            Path path = (Path)AnnotationUtils.getMethodAnnotation(annotatedMethod, Path.class);
            if (httpMethod == null && path == null) continue;
            md.bind(this.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), m);
            if (httpMethod != null || !this.checkMethodDispatcher(subCri = this.createClassResourceInfo(subResourceClass = m.getReturnType(), subResourceClass, false))) continue;
            cri.addSubClassResourceInfo(subCri);
        }
        return md;
    }

    private OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        OperationResourceInfo ori = new OperationResourceInfo(m, cri);
        URITemplate t = URITemplate.createTemplate(cri, path);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        ori.setAnnotatedMethod(annotatedMethod);
        return ori;
    }

    private boolean checkMethodDispatcher(ClassResourceInfo cr) {
        if (cr.getMethodDispatcher().getOperationResourceInfos().isEmpty()) {
            LOG.warning(new Message("NO_RESOURCE_OP_EXC", BUNDLE, new Object[]{cr.getClass().getName()}).toString());
            return false;
        }
        return true;
    }

    protected Invoker createInvoker() {
        return new JAXRSInvoker();
    }
}

