/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private Message m;
    private MultivaluedMap<String, String> headers;

    public HttpHeadersImpl(Message message) {
        this.m = message;
        this.headers = new MetadataMap<String, String>((Map)message.get((Object)Message.PROTOCOL_HEADERS));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return JAXRSUtils.sortMediaTypes((String)this.m.get((Object)"Accept"));
    }

    public Map<String, Cookie> getCookies() {
        List cs = (List)this.headers.get((Object)"Cookie");
        HashMap<String, Cookie> cl = new HashMap<String, Cookie>();
        for (String c : cs) {
            Cookie cookie = Cookie.valueOf((String)c);
            cl.put(cookie.getName(), cookie);
        }
        return cl;
    }

    public String getLanguage() {
        String l = (String)this.headers.getFirst((Object)"Content-Language");
        return l == null ? "UTF-8" : l;
    }

    public MediaType getMediaType() {
        return MediaType.valueOf((String)((String)this.m.get((Object)"Content-Type")));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        for (String key : this.headers.keySet()) {
            map.put(key, this.getRequestHeader(key));
        }
        return map;
    }

    public List<String> getAcceptableLanguages() {
        List values = (List)this.headers.get((Object)"Accept-Language");
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> newLs = new ArrayList<String>();
        String[] ls = ((String)values.get(0)).split(",");
        HashMap<String, Float> prefs = new HashMap<String, Float>();
        for (String l : ls) {
            String[] pair = l.split(";");
            newLs.add(pair[0]);
            if (pair.length > 1) {
                String[] pair2 = pair[1].split("=");
                if (pair2.length > 1) {
                    prefs.put(pair[0], Float.valueOf(JAXRSUtils.getMediaTypeQualityFactor(pair2[1])));
                    continue;
                }
                prefs.put(pair[0], Float.valueOf(1.0f));
                continue;
            }
            prefs.put(pair[0], Float.valueOf(1.0f));
        }
        if (newLs.size() == 1) {
            return newLs;
        }
        Collections.sort(newLs, new AcceptLanguageComparator(prefs));
        return newLs;
    }

    public List<String> getRequestHeader(String name) {
        String[] ls;
        List values = (List)this.headers.get((Object)name);
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> hValues = new ArrayList<String>();
        for (String s : ls = ((String)values.get(0)).split(",")) {
            hValues.add(s.trim());
        }
        return hValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptLanguageComparator
    implements Comparator<String> {
        private Map<String, Float> prefs;

        public AcceptLanguageComparator(Map<String, Float> prefs) {
            this.prefs = prefs;
        }

        @Override
        public int compare(String lang1, String lang2) {
            float p2;
            float p1 = this.prefs.get(lang1).floatValue();
            int result = Float.compare(p1, p2 = this.prefs.get(lang2).floatValue());
            return result == 0 ? result : ~result;
        }
    }
}

