/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormUtils {
    private FormUtils() {
    }

    public static String readBody(InputStream is) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos, (int)1024);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public static void populateMap(MultivaluedMap<String, String> params, String postBody, boolean decode) {
        if (!StringUtils.isEmpty((String)postBody)) {
            List<String> parts = Arrays.asList(postBody.split("&"));
            for (String part : parts) {
                String[] keyValue = part.split("=");
                if (keyValue.length == 2) {
                    if (decode) {
                        params.add((Object)keyValue[0], (Object)JAXRSUtils.uriDecode(keyValue[1]));
                        continue;
                    }
                    params.add((Object)keyValue[0], (Object)keyValue[1]);
                    continue;
                }
                params.add((Object)keyValue[0], (Object)"");
            }
        }
    }
}

