/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private MultivaluedMap<String, String> templateParams;
    private Message message;

    public UriInfoImpl(Message m, MultivaluedMap<String, String> templateParams) {
        this.message = m;
        this.templateParams = templateParams;
    }

    public URI getAbsolutePath() {
        String path = this.getAbsolutePathAsString();
        return URI.create(path);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        URI u = URI.create(HttpUtils.getEndpointAddress(this.message));
        return HttpUtils.toAbsoluteUri(u, this.message);
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl(this.getBaseUri());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.doGetPath(decode, true);
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return JAXRSUtils.getPathSegments(this.getPath(), decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return JAXRSUtils.getStructuredParams((String)this.message.get(Message.QUERY_STRING), "&", decode);
    }

    public URI getRequestUri() {
        String path = this.getAbsolutePathAsString();
        String queries = (String)this.message.get(Message.QUERY_STRING);
        if (queries != null) {
            path = path + "?" + queries;
        }
        return URI.create(path);
    }

    public UriBuilder getRequestUriBuilder() {
        return new UriBuilderImpl(this.getRequestUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add((String)entry.getKey(), decode ? JAXRSUtils.uriDecode((String)((List)entry.getValue()).get(0)) : (String)((List)entry.getValue()).get(0));
        }
        return values;
    }

    public List<String> getAncestorResourceURIs() {
        return null;
    }

    public List<Object> getAncestorResources() {
        return null;
    }

    public List<String> getAncestorResourceURIs(boolean arg0) {
        return null;
    }

    public String getPathExtension() {
        return null;
    }

    public UriBuilder getPlatonicRequestUriBuilder() {
        return null;
    }

    private String doGetPath(boolean decode, boolean addSlash) {
        String path = HttpUtils.getPathToMatch(this.message, addSlash);
        return decode ? JAXRSUtils.uriDecode(path) : path;
    }

    private String getAbsolutePathAsString() {
        String address = this.getBaseUri().toString();
        String path = this.doGetPath(true, false);
        if (path.startsWith("/") && address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        return address + path;
    }
}

