/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.PathSegment;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.servlet.ServletDestination;

public final class HttpUtils {
    private static final String LOCAL_IP_ADDRESS = "127.0.0.1";
    private static final String LOCAL_HOST = "localhost";

    private HttpUtils() {
    }

    public static URI toAbsoluteUri(URI u, Message message) {
        HttpServletRequest httpRequest;
        if (!u.isAbsolute() && (httpRequest = (HttpServletRequest)message.get("HTTP.REQUEST")) != null) {
            String scheme = httpRequest.isSecure() ? "https" : "http";
            String host = httpRequest.getLocalName();
            if (LOCAL_IP_ADDRESS.equals(host)) {
                host = LOCAL_HOST;
            }
            int port = httpRequest.getLocalPort();
            return URI.create(scheme + "://" + host + ':' + port + u.toString());
        }
        return u;
    }

    public static String getPathToMatch(Message m, boolean addSlash) {
        String requestAddress = (String)m.get(Message.REQUEST_URI);
        String baseAddress = HttpUtils.getBaseAddress(m);
        return HttpUtils.getPathToMatch(requestAddress, baseAddress, addSlash);
    }

    public static String getBaseAddress(Message m) {
        try {
            String endpointAddress = HttpUtils.getEndpointAddress(m);
            return new URL(endpointAddress).getPath();
        }
        catch (MalformedURLException ex) {
            return (String)m.get(Message.BASE_PATH);
        }
    }

    public static String getEndpointAddress(Message m) {
        String address = null;
        Destination d = m.getExchange().getDestination();
        address = d instanceof ServletDestination ? ((ServletDestination)d).getEndpointInfo().getAddress() : d.getAddress().getAddress().getValue();
        return address;
    }

    public static String getPathToMatch(String path, String address, boolean addSlash) {
        int ind = path.indexOf(address);
        if (ind == 0) {
            path = path.substring(ind + address.length());
        }
        if (addSlash && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public static String getOriginalAddress(Message m) {
        Destination d = m.getDestination();
        return d == null ? "/" : d.getAddress().getAddress().getValue();
    }

    public static String fromPathSegment(PathSegment ps) {
        if (PathSegmentImpl.class.isAssignableFrom(ps.getClass())) {
            return ((PathSegmentImpl)ps).getOriginalPath();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        for (Map.Entry entry : ps.getMatrixParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sb.append(';').append((String)entry.getKey());
                if (value == null) continue;
                sb.append('=').append(value);
            }
        }
        return sb.toString();
    }
}

