/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.NamedItem;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingInfo
extends AbstractDescriptionElement
implements NamedItem {
    private static final Logger LOG = LogUtils.getL7dLogger(BindingInfo.class);
    QName name;
    ServiceInfo service;
    final String bindingId;
    Map<QName, BindingOperationInfo> operations = new ConcurrentHashMap<QName, BindingOperationInfo>(4);

    public BindingInfo(ServiceInfo service, String bindingId) {
        this.service = service;
        this.bindingId = bindingId;
    }

    public InterfaceInfo getInterface() {
        return this.service.getInterface();
    }

    public ServiceInfo getService() {
        return this.service;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setName(QName n) {
        this.name = n;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    private boolean nameEquals(String a, String b, String def) {
        if (a == null) {
            return true;
        }
        if (b == null) {
            b = def;
        }
        return "".equals(a) ? "".equals(b) : a.equals(b);
    }

    public BindingOperationInfo buildOperation(QName opName, String inName, String outName) {
        for (OperationInfo op : this.getInterface().getOperations()) {
            if (!opName.equals(op.getName()) || !this.nameEquals(inName, op.getInputName(), op.getName().getLocalPart() + "Request") || !this.nameEquals(outName, op.getOutputName(), op.getName().getLocalPart() + "Response")) continue;
            return new BindingOperationInfo(this, op);
        }
        return null;
    }

    public void addOperation(BindingOperationInfo operation) {
        if (operation.getName() == null) {
            throw new NullPointerException(new Message("BINDING.OPERATION.NAME.NOT.NULL", LOG, new Object[0]).toString());
        }
        if (this.operations.containsKey(operation.getName())) {
            throw new IllegalArgumentException(new Message("DUPLICATED.OPERATION.NAME", LOG, operation.getName()).toString());
        }
        this.operations.put(operation.getName(), operation);
    }

    public void removeOperation(BindingOperationInfo operation) {
        if (operation.getName() == null) {
            throw new NullPointerException(new Message("BINDING.OPERATION.NAME.NOT.NULL", LOG, new Object[0]).toString());
        }
        this.operations.remove(operation.getName());
    }

    public BindingOperationInfo getOperation(QName oname) {
        return this.operations.get(oname);
    }

    public Collection<BindingOperationInfo> getOperations() {
        return Collections.unmodifiableCollection(this.operations.values());
    }

    public BindingOperationInfo getOperation(OperationInfo oi) {
        for (BindingOperationInfo b : this.operations.values()) {
            if (b.getOperationInfo() == oi) {
                return b;
            }
            if (!b.isUnwrappedCapable() || b.getUnwrappedOperation().getOperationInfo() != oi) continue;
            return b.getUnwrappedOperation();
        }
        return null;
    }

    public String toString() {
        return "[BindingInfo " + this.getBindingId() + "]";
    }
}

