/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.cxf.CXFInvocationHandlerData;
import org.apache.cxf.jca.cxf.handlers.CXFInvocationHandlerBase;

public class InvokingInvocationHandler
extends CXFInvocationHandlerBase {
    private static final Logger LOG = LogUtils.getL7dLogger(InvokingInvocationHandler.class);

    public InvokingInvocationHandler(CXFInvocationHandlerData data) {
        super(data);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        if (!this.isConnectionCloseMethod(method)) {
            ret = this.invokeTargetMethod(proxy, method, args);
        } else {
            this.closeConnection(proxy);
        }
        return ret;
    }

    private boolean isConnectionCloseMethod(Method m) {
        return "close".equals(m.getName());
    }

    private void closeConnection(Object handle) throws ResourceException {
        LOG.fine("calling close on managed connection with handle");
        this.getData().getManagedConnection().close(handle);
    }

    private Object invokeTargetMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        try {
            ret = method.invoke(this.getData().getTarget(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return ret;
    }
}

