/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPolicyImpl
implements EndpointPolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EndpointPolicyImpl.class);
    private Policy policy;
    private Collection<PolicyAssertion> chosenAlternative;
    private Collection<PolicyAssertion> vocabulary;
    private Collection<PolicyAssertion> faultVocabulary;
    private List<Interceptor> interceptors;
    private List<Interceptor> faultInterceptors;
    private EndpointInfo ei;
    private PolicyEngineImpl engine;
    private boolean requestor;
    private Assertor assertor;

    public EndpointPolicyImpl() {
    }

    public EndpointPolicyImpl(EndpointInfo ei, PolicyEngineImpl engine, boolean requestor, Assertor assertor) {
        this.ei = ei;
        this.engine = engine;
        this.requestor = requestor;
        this.assertor = assertor;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public EndpointPolicy updatePolicy(Policy p) {
        EndpointPolicyImpl epi = this.createEndpointPolicy();
        Policy np = (Policy)p.normalize(true);
        epi.setPolicy(this.getPolicy().merge(np));
        epi.checkExactlyOnes();
        epi.finalizeConfig();
        return epi;
    }

    public Collection<PolicyAssertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    public Collection<PolicyAssertion> getVocabulary() {
        return this.vocabulary;
    }

    public Collection<PolicyAssertion> getFaultVocabulary() {
        return this.faultVocabulary;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<Interceptor> getFaultInterceptors() {
        return this.faultInterceptors;
    }

    void initialize() {
        this.initializePolicy();
        this.checkExactlyOnes();
        this.finalizeConfig();
    }

    void finalizeConfig() {
        this.chooseAlternative();
        this.initializeVocabulary();
        this.initializeInterceptors();
    }

    void initializePolicy() {
        this.policy = this.engine.getAggregatedServicePolicy(this.ei.getService());
        this.policy = this.policy.merge(this.engine.getAggregatedEndpointPolicy(this.ei));
        if (!this.policy.isEmpty()) {
            this.policy = (Policy)this.policy.normalize(true);
        }
    }

    void chooseAlternative() {
        Collection alternative = null;
        alternative = this.requestor ? this.engine.getAlternativeSelector().selectAlternative(this.policy, (PolicyEngine)this.engine, this.assertor) : this.getSupportedAlternatives();
        if (null == alternative) {
            throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    protected Collection<PolicyAssertion> getSupportedAlternatives() {
        ArrayList<PolicyAssertion> alternatives = new ArrayList<PolicyAssertion>();
        Iterator it = this.policy.getAlternatives();
        while (it.hasNext()) {
            List alternative = CastUtils.cast((List)((List)it.next()), PolicyAssertion.class);
            if (!this.engine.supportsAlternative(alternative, this.assertor)) continue;
            alternatives.addAll(alternative);
        }
        return alternatives;
    }

    void initializeVocabulary() {
        this.vocabulary = new ArrayList<PolicyAssertion>();
        if (this.requestor) {
            this.faultVocabulary = new ArrayList<PolicyAssertion>();
        }
        for (PolicyAssertion a : this.getChosenAlternative()) {
            if (a.isOptional()) continue;
            this.vocabulary.add(a);
            if (null == this.faultVocabulary) continue;
            this.faultVocabulary.add(a);
        }
        for (BindingOperationInfo boi : this.ei.getBinding().getOperations()) {
            Policy p = this.engine.getAggregatedOperationPolicy(boi);
            Collection<PolicyAssertion> c = this.engine.getAssertions((PolicyComponent)p, false);
            this.vocabulary.addAll(c);
            if (null != this.faultVocabulary) {
                this.faultVocabulary.addAll(c);
            }
            if (!this.requestor) {
                p = this.engine.getAggregatedMessagePolicy(boi.getInput());
                this.vocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
                continue;
            }
            if (null == boi.getOutput()) continue;
            p = this.engine.getAggregatedMessagePolicy(boi.getOutput());
            this.vocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
            for (BindingFaultInfo bfi : boi.getFaults()) {
                p = this.engine.getAggregatedFaultPolicy(bfi);
                this.faultVocabulary.addAll(this.engine.getAssertions((PolicyComponent)p, false));
            }
        }
    }

    void initializeInterceptors() {
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)this.engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        this.interceptors = new ArrayList<Interceptor>();
        if (this.requestor) {
            this.faultInterceptors = new ArrayList<Interceptor>();
        }
        HashSet<QName> v = new HashSet<QName>();
        for (PolicyAssertion a : this.vocabulary) {
            v.add(a.getName());
        }
        for (QName qn : v) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
            if (null == pp) continue;
            this.interceptors.addAll(pp.getInInterceptors());
        }
        if (!this.requestor) {
            return;
        }
        HashSet<QName> faultV = new HashSet<QName>();
        for (PolicyAssertion a : this.faultVocabulary) {
            faultV.add(a.getName());
        }
        for (QName qn : faultV) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
            if (null == pp) continue;
            this.faultInterceptors.addAll(pp.getInFaultInterceptors());
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<PolicyAssertion> c) {
        this.chosenAlternative = c;
    }

    void setVocabulary(Collection<PolicyAssertion> v) {
        this.vocabulary = v;
    }

    void setFaultVocabulary(Collection<PolicyAssertion> v) {
        this.faultVocabulary = v;
    }

    void setInterceptors(List<Interceptor> in) {
        this.interceptors = in;
    }

    void setFaultInterceptors(List<Interceptor> inFault) {
        this.faultInterceptors = inFault;
    }

    protected EndpointPolicyImpl createEndpointPolicy() {
        return new EndpointPolicyImpl(this.ei, this.engine, this.requestor, this.assertor);
    }

    void checkExactlyOnes() {
        List assertions = this.policy.getPolicyComponents();
        if (assertions.size() <= 1) {
            return;
        }
        Policy p = new Policy();
        ExactlyOne alternatives = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)alternatives);
        for (Object a : assertions) {
            alternatives.addPolicyComponents(((ExactlyOne)a).getPolicyComponents());
        }
        this.setPolicy(p);
    }
}

