/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.Tag;
import org.apache.cxf.tools.common.ToolException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StAXUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(StAXUtil.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    private StAXUtil() {
    }

    public static void toStartTag(XMLStreamReader r) throws XMLStreamException {
        while (!r.isStartElement() && r.hasNext()) {
            r.next();
        }
    }

    public static XMLStreamReader createFreshXMLStreamReader(InputSource source) {
        try {
            if (source.getCharacterStream() != null) {
                return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), source.getCharacterStream());
            }
            if (source.getByteStream() != null) {
                return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), source.getByteStream());
            }
            return XML_INPUT_FACTORY.createXMLStreamReader(source.getSystemId(), new URL(source.getSystemId()).openStream());
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_CREATE_STAX", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    public static List<Tag> getTags(File source) throws Exception {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List<String> ignoreEmptyTags = Arrays.asList("sequence");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(is);
        Tag newTag = null;
        int count = 0;
        QName checkingPoint = null;
        Stack<Tag> stack = new Stack<Tag>();
        while (reader.hasNext()) {
            int event = reader.next();
            if (checkingPoint != null) {
                ++count;
            }
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (ignoreEmptyTags.contains(reader.getLocalName())) {
                    checkingPoint = reader.getName();
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    newTag.getAttributes().put(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
                stack.push(newTag);
            }
            if (event == 4) {
                newTag.setText(reader.getText());
            }
            if (event != 2) continue;
            Tag startTag = (Tag)stack.pop();
            if (checkingPoint != null && checkingPoint.equals(reader.getName())) {
                if (count != 1) {
                    tags.add(startTag);
                }
                count = 0;
                checkingPoint = null;
                continue;
            }
            tags.add(startTag);
        }
        reader.close();
        return tags;
    }

    public static Tag getTagTree(File source) throws Exception {
        return StAXUtil.getTagTree(source, new ArrayList<String>());
    }

    public static Tag getTagTree(File source, List<String> ignoreAttr) throws Exception {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        return StAXUtil.getTagTree(is, ignoreAttr);
    }

    public static Tag getTagTree(InputStream is, List<String> ignoreAttr) throws Exception {
        Tag root = new Tag();
        root.setName(new QName("root", "root"));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(is);
        Tag newTag = null;
        Tag currentTag = root;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (!ignoreAttr.isEmpty()) {
                    newTag.getIgnoreAttr().addAll(ignoreAttr);
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if ("type".equals(reader.getAttributeLocalName(i)) && "element".equals(reader.getLocalName())) {
                        String tp = reader.getAttributeValue(i);
                        if (tp.contains(":")) {
                            String ns = tp.substring(0, tp.indexOf(":"));
                            if ("tns".equals(ns)) {
                                tp = tp.substring(tp.indexOf(":") + 1);
                            } else {
                                ns = reader.getNamespaceURI(ns);
                                tp = "{" + ns + "}" + tp.substring(tp.indexOf(":") + 1);
                            }
                        }
                        newTag.getAttributes().put(reader.getAttributeName(i), tp);
                        continue;
                    }
                    newTag.getAttributes().put(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
                newTag.setParent(currentTag);
                currentTag.getTags().add(newTag);
                currentTag = newTag;
            }
            if (event == 4) {
                newTag.setText(reader.getText());
            }
            if (event != 2) continue;
            currentTag = currentTag.getParent();
        }
        reader.close();
        return root;
    }

    public Tag getLastTag(Tag tag) {
        int lastIndex = tag.getTags().size() - 1;
        return tag.getTags().get(lastIndex);
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
    }
}

