/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.core.NamedThreadLocal;

public class ExposeInvocationInterceptor
implements MethodInterceptor,
Serializable {
    public static final ExposeInvocationInterceptor INSTANCE = new ExposeInvocationInterceptor();
    public static final Advisor ADVISOR = new DefaultPointcutAdvisor(INSTANCE){

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return (class$org$springframework$aop$interceptor$ExposeInvocationInterceptor == null ? (class$org$springframework$aop$interceptor$ExposeInvocationInterceptor = ExposeInvocationInterceptor.class$("org.springframework.aop.interceptor.ExposeInvocationInterceptor")) : class$org$springframework$aop$interceptor$ExposeInvocationInterceptor).getName() + ".ADVISOR";
        }
    };
    private static final ThreadLocal invocation = new NamedThreadLocal("Current AOP method invocation");
    static /* synthetic */ Class class$org$springframework$aop$interceptor$ExposeInvocationInterceptor;

    public static MethodInvocation currentInvocation() throws IllegalStateException {
        MethodInvocation mi = (MethodInvocation)invocation.get();
        if (mi == null) {
            throw new IllegalStateException("No MethodInvocation found: Check that an AOP invocation is in progress, and that the ExposeInvocationInterceptor is in the interceptor chain.");
        }
        return mi;
    }

    private ExposeInvocationInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object old = invocation.get();
        invocation.set(mi);
        try {
            Object object = mi.proceed();
            return object;
        }
        finally {
            invocation.set(old);
        }
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

