/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container.classloader;

import com.iona.cxf.container.ContainerException;
import com.iona.cxf.container.classloader.FirewallClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationClassLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(ApplicationClassLoader.class);
    private static final String LIB_DIR = "WEB-INF/lib";
    private static final String CLASSES_DIR = "WEB-INF/classes";
    private static final String WSDL_DIR = "WEB-INF/wsdl";
    private static final String META_INF_DIR = "META-INF";
    private static final String[] ILLEGAL_PACKAGE_NAMES = new String[]{"java", "com/sun", "sun", "org/omg", "javax"};
    private static final String JAR_EXT = ".jar";

    private ApplicationClassLoader() {
    }

    public static ClassLoader createClassLoader(File appDir) throws ContainerException {
        ClassLoader parent = new ApplicationClassLoader().getClass().getClassLoader();
        return ApplicationClassLoader.createClassLoader(appDir, parent);
    }

    public static ClassLoader createClassLoader(File appDir, ClassLoader realParent) throws ContainerException {
        HashMap<String, Object> resourceTree = new HashMap<String, Object>();
        URLClassLoader loader = null;
        try {
            File[] jars;
            File wsdlDir;
            File metaDir;
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(appDir.toURL());
            File classDir = new File(appDir, CLASSES_DIR);
            if (classDir.exists()) {
                urls.add(classDir.toURL());
                ApplicationClassLoader.addResourcesFromDir(classDir, "", resourceTree);
            }
            if ((metaDir = new File(appDir, META_INF_DIR)).exists()) {
                urls.add(metaDir.toURL());
                ApplicationClassLoader.addResourcesFromDir(metaDir, "", resourceTree);
            }
            if ((wsdlDir = new File(appDir, WSDL_DIR)).exists()) {
                urls.add(wsdlDir.toURL());
                ApplicationClassLoader.addResourcesFromDir(wsdlDir, "", resourceTree);
            }
            for (File jar : jars = ApplicationClassLoader.getJarFiles(appDir)) {
                urls.add(jar.toURL());
            }
            for (File file : jars) {
                if (file.isDirectory()) {
                    ApplicationClassLoader.addResourcesFromDir(file, "", resourceTree);
                    continue;
                }
                JarFile jar = new JarFile(file);
                ApplicationClassLoader.addResoucesFromJar(jar, resourceTree);
            }
            ApplicationClassLoader.inspectResourceTreeForIllegalPackages(resourceTree);
            FirewallClassLoader parent = new FirewallClassLoader(realParent, resourceTree);
            for (URL url : urls) {
                LOG.fine("Adding URL to ClassLoader; " + url);
            }
            loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)parent);
        }
        catch (MalformedURLException muex) {
            throw new ContainerException(muex);
        }
        catch (IOException ioex) {
            throw new ContainerException(ioex);
        }
        return loader;
    }

    private static File[] getJarFiles(File appDir) {
        File libDir = new File(appDir, LIB_DIR);
        if (libDir.exists() && libDir.isDirectory()) {
            File[] jars = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(ApplicationClassLoader.JAR_EXT);
                }
            });
            if (jars == null) {
                return new File[0];
            }
            return jars;
        }
        return new File[0];
    }

    private static void addResourcesFromDir(File dir, String relativePath, Map<String, Object> map) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            String path = relativePath + "/" + file.getName();
            if (file.isDirectory()) {
                ApplicationClassLoader.addResourcesFromDir(file, path, map);
                continue;
            }
            List<String> list = ApplicationClassLoader.tokenizeResource(path);
            ApplicationClassLoader.insertResourceIntoMap(map, list);
        }
    }

    private static void addResoucesFromJar(JarFile jar, Map<String, Object> resources) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            List<String> list = ApplicationClassLoader.tokenizeResource(name);
            ApplicationClassLoader.insertResourceIntoMap(resources, list);
        }
    }

    private static void insertResourceIntoMap(Map<String, Object> map, List<String> list) {
        if (list.size() > 1) {
            String dir = list.get(0);
            Object obj = map.get(dir);
            HashMap<String, Object> submap = CastUtils.cast((Map)((Map)obj));
            if (submap == null) {
                submap = new HashMap<String, Object>();
                map.put(dir, submap);
            }
            List<String> sublist = list.subList(1, list.size());
            ApplicationClassLoader.insertResourceIntoMap(submap, sublist);
        } else {
            String resourceName = list.get(0);
            map.put(resourceName, resourceName);
        }
    }

    private static List<String> tokenizeResource(String resourceName) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(resourceName, "/");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private static void inspectResourceTreeForIllegalPackages(Map<String, Object> tree) throws ContainerException {
        Map map = tree;
        for (String packageName : ILLEGAL_PACKAGE_NAMES) {
            List<String> list = ApplicationClassLoader.tokenizeResource(packageName);
            for (String name : list) {
                Object obj = map.get(name);
                if (obj == null) {
                    return;
                }
                map = CastUtils.cast((Map)((Map)obj));
            }
            if (map == null) continue;
            throw new ContainerException(new Message("ILLEGAL_PACKAGE", LOG, new Object[]{packageName}));
        }
    }
}

