/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.tools.common.model.JAnnotationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotation {
    private Class type;
    private List<JAnnotationElement> elements = new ArrayList<JAnnotationElement>();
    private Set<String> imports = new HashSet<String>();

    public JAnnotation() {
    }

    public JAnnotation(Class t) {
        this.setType(t);
    }

    public Set<String> getImports() {
        this.prompt();
        for (JAnnotationElement element : this.elements) {
            this.imports.addAll(element.getImports());
        }
        return this.imports;
    }

    private void prompt() {
        this.toString();
    }

    public List<JAnnotationElement> getElements() {
        return this.elements;
    }

    public void addElement(JAnnotationElement element) {
        if (this.elements.contains(element)) {
            return;
        }
        JAnnotationElement e = this.getElementByName(element.getName());
        if (e != null) {
            this.elements.remove(e);
        }
        this.elements.add(element);
    }

    private JAnnotationElement getElementByName(String name) {
        if (name != null) {
            for (JAnnotationElement e : this.elements) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
        }
        return null;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class newType) {
        this.type = newType;
        this.imports.add(this.type.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        sb.append(this.type.getSimpleName());
        if (this.getElements().isEmpty()) {
            return sb.toString();
        }
        sb.append("(");
        for (int i = 0; i < this.elements.size(); ++i) {
            sb.append(this.elements.get(i));
            if (i >= this.elements.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

