/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.X509NameTokenizer;

public abstract class CryptoBase
implements Crypto {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$components$crypto$CryptoBase == null ? (class$org$apache$ws$security$components$crypto$CryptoBase = CryptoBase.class$("org.apache.ws.security.components.crypto.CryptoBase")) : class$org$apache$ws$security$components$crypto$CryptoBase));
    protected static CertificateFactory certFact;
    protected KeyStore keystore = null;
    static String SKI_OID;
    protected KeyStore cacerts = null;
    static /* synthetic */ Class class$org$apache$ws$security$components$crypto$CryptoBase;

    protected CryptoBase() {
    }

    protected abstract String getCryptoProvider();

    public synchronized CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (certFact == null) {
            try {
                String provider = this.getCryptoProvider();
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType", null, e);
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider", null, e);
            }
        }
        return certFact;
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
        return cert;
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        if (alias == null) {
            throw new Exception("alias is null");
        }
        boolean b = this.keystore.isKeyEntry(alias);
        if (!b) {
            log.error((Object)("Cannot find key for alias: " + alias));
            throw new Exception("Cannot find key for alias: " + alias);
        }
        Key keyTmp = this.keystore.getKey(alias, password.toCharArray());
        if (!(keyTmp instanceof PrivateKey)) {
            throw new Exception("Key is not a private key, alias: " + alias);
        }
        return (PrivateKey)keyTmp;
    }

    protected Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, null, false);
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, serialNumber, true);
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber) throws WSSecurityException {
        X500Principal issuerRDN = new X500Principal(issuer);
        Certificate cert = null;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                X500Principal certRDN;
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509cert = (X509Certificate)cert;
                if (useSerialNumber && (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0) || !(certRDN = new X500Principal(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return null;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        Certificate cert = null;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert((X509Certificate)cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return null;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            String alias = this.keystore.getCertificateAlias(cert);
            if (alias != null) {
                return alias;
            }
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                X509Certificate cert2 = (X509Certificate)this.keystore.getCertificate(alias);
                if (!cert2.equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return null;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        Certificate[] certs = null;
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.cacerts != null && (certs = this.cacerts.getCertificateChain(alias)) == null) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                certs = new Certificate[]{cert};
            } else if (certs == null) {
                return null;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        Certificate cert = null;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "noSHA1availabe", null, e);
        }
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    throw new WSSecurityException(7, "encodeError", null, ex);
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return null;
    }

    public void setKeyStore(KeyStore ks) {
        this.keystore = ks;
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"}, ex);
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        X500Principal subjectRDN = new X500Principal(subjectDN);
        Vector aliases = this.getAlias(subjectRDN, this.keystore);
        if (aliases.size() == 0) {
            aliases = this.getAlias(subjectRDN, this.cacerts);
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.insertElementAt(certs[i], 0);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError", null, e);
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        try {
            List<X509Certificate> cert_list = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(cert_list);
            PKIXParameters param = new PKIXParameters(this.keystore);
            param.setRevocationEnabled(false);
            String provider = this.getCryptoProvider();
            CertPathValidator validator = null;
            validator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            validator.validate(path, param);
        }
        catch (NoSuchProviderException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertPathValidatorException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        return true;
    }

    private Vector getAlias(X500Principal subjectRDN, KeyStore store) throws WSSecurityException {
        Vector<String> aliases = new Vector<String>();
        Certificate cert = null;
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                X500Principal foundRDN;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = ((X509Certificate)cert).getSubjectX500Principal())) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore", null, e);
        }
        return aliases;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SKI_OID = "2.5.29.14";
    }
}

