/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyException;

public class PolicyVerificationOutInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyVerificationOutInterceptor.class);

    public PolicyVerificationOutInterceptor() {
        super("post-stream");
    }

    protected void handle(Message message) {
        if (MessageUtils.isPartialResponse((Message)message)) {
            LOG.fine("Not verifying policies on outbound partial response.");
            return;
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        this.getTransportAssertions(message);
        EffectivePolicy policy = (EffectivePolicy)message.get(EffectivePolicy.class);
        if (policy == null) {
            return;
        }
        try {
            aim.checkEffectivePolicy(policy.getPolicy());
        }
        catch (PolicyException e) {
            if (this.isOutboundServer(message)) {
                LOG.fine("An exception was thrown when verifying that the effective policy for this request was satisfied.  However, this exception will not result in a fault.  The exception raised is: " + e.toString());
                return;
            }
            throw e;
        }
        LOG.fine("Verified policies for outbound message.");
    }

    private boolean isOutboundServer(Message message) {
        Object role = message.get((Object)"org.apache.cxf.client");
        boolean isClient = role != null ? Boolean.TRUE.equals(role) : false;
        boolean isOutbound = message == message.getExchange().getOutMessage() || message == message.getExchange().getOutFaultMessage();
        return !isClient && isOutbound;
    }
}

