/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String HTTP_CONFIG = "HTTP.CONFIG";
    public static final String PROTOCOL_HEADERS_CONTENT_TYPE = "Content-Type".toLowerCase();
    public static final String PARTIAL_RESPONSE = AbstractMultiplexDestination.class.getName() + ".partial.response";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    private static final long serialVersionUID = 1L;
    protected final Bus bus;
    protected final ConduitInitiator conduitInitiator;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy = "stem";
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;

    public AbstractHTTPDestination(Bus b, ConduitInitiator ci, EndpointInfo ei, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference(AbstractHTTPDestination.getAddressValue(ei, dp), b), ei);
        this.bus = b;
        this.conduitInitiator = ci;
        this.initConfig();
    }

    protected void setHeaders(Message message) {
        List authorizationLines;
        String credentials;
        String authType;
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        this.copyRequestHeaders(message, requestHeaders);
        message.put(Message.PROTOCOL_HEADERS, requestHeaders);
        if (requestHeaders.containsKey("Authorization") && "Basic".equals(authType = (credentials = (String)(authorizationLines = (List)requestHeaders.get("Authorization")).get(0)).split(" ")[0])) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode(authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo.length > 0 ? authInfo[0] : "";
                String password = authInfo.length > 1 ? authInfo[1] : "";
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                message.put(AuthorizationPolicy.class, policy);
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Request Headers: " + ((Object)requestHeaders).toString());
        }
    }

    protected void updateResponseHeaders(Message message) {
        Map<String, List<String>> responseHeaders = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (responseHeaders == null) {
            responseHeaders = new HashMap<String, List<String>>();
            message.put(Message.PROTOCOL_HEADERS, responseHeaders);
        }
        this.setPolicies(responseHeaders);
    }

    protected final boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex == null ? false : ex.isOneWay();
    }

    @Override
    protected ConduitInitiator getConduitInitiator() {
        return this.conduitInitiator;
    }

    protected void copyRequestHeaders(Message message, Map<String, List<String>> headers) {
        HttpServletRequest req = (HttpServletRequest)message.get(HTTP_REQUEST);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            String mappedName = HttpHeaderHelper.getHeaderKey(fname);
            if (headers.containsKey(mappedName)) {
                values = headers.get(mappedName);
            } else {
                values = new ArrayList();
                headers.put(mappedName, values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
    }

    protected void copyResponseHeaders(Message message, HttpServletResponse response) {
        Map headers;
        String ct = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != ct && null != enc && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
            ct = ct + "; charset=" + enc;
        }
        if (null != (headers = (Map)message.get(Message.PROTOCOL_HEADERS))) {
            if (!headers.containsKey("Content-Type")) {
                response.setContentType(ct);
            }
            for (String header : headers.keySet()) {
                List headerList = (List)headers.get(header);
                for (Object value : headerList) {
                    response.addHeader(header, (String)value);
                }
            }
        } else {
            response.setContentType(ct);
        }
    }

    protected void setupMessage(Message inMessage, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupMessage(inMessage, null, context, req, resp);
    }

    protected void setupMessage(Message inMessage, ServletConfig config, ServletContext context, final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String normalizedEncoding;
        inMessage.setContent(InputStream.class, req.getInputStream());
        inMessage.put(HTTP_REQUEST, req);
        inMessage.put(HTTP_RESPONSE, resp);
        inMessage.put(HTTP_CONTEXT, context);
        inMessage.put(HTTP_CONFIG, config);
        inMessage.put(Message.HTTP_REQUEST_METHOD, req.getMethod());
        inMessage.put(Message.REQUEST_URI, req.getRequestURI());
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        inMessage.put(Message.PATH_INFO, contextPath + req.getPathInfo());
        String enc = req.getCharacterEncoding();
        if (enc != null && enc.endsWith("\"")) {
            enc = enc.substring(0, enc.length() - 1);
        }
        if ((normalizedEncoding = HttpHeaderHelper.mapCharset(enc)) == null) {
            String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, enc).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        inMessage.put(Message.ENCODING, normalizedEncoding);
        inMessage.put(Message.QUERY_STRING, req.getQueryString());
        inMessage.put("Content-Type", req.getContentType());
        inMessage.put("Accept", req.getHeader("Accept"));
        String basePath = this.getBasePath(contextPath);
        if (!StringUtils.isEmpty(basePath)) {
            inMessage.put(Message.BASE_PATH, basePath);
        }
        inMessage.put(Message.FIXED_PARAMETER_ORDER, this.isFixedParameterOrder());
        inMessage.put("org.apache.cxf.async.post.response.dispatch", Boolean.TRUE);
        inMessage.put(SecurityContext.class, new SecurityContext(){

            public Principal getUserPrincipal() {
                return req.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }
        });
        this.setHeaders(inMessage);
        SSLUtils.propogateSecureSession(req, inMessage);
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty(this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.endpointInfo.getAddress()).getPath();
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        return AbstractHTTPDestination.getAddressValue(ei, true);
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        if (dp) {
            String addr;
            String eiAddress = ei.getAddress();
            if (eiAddress == null) {
                try {
                    ServerSocket s = new ServerSocket(0);
                    ei.setAddress("http://localhost:" + s.getLocalPort());
                    s.close();
                    return ei;
                }
                catch (IOException ex) {
                    ei.setAddress("http://localhost");
                }
            }
            if ((addr = StringUtils.addDefaultPortIfMissing(ei.getAddress())) != null) {
                ei.setAddress(addr);
            }
        }
        return ei;
    }

    @Override
    protected Conduit getInbuiltBackChannel(Message inMessage) {
        HttpServletResponse response = (HttpServletResponse)inMessage.get(HTTP_RESPONSE);
        return new BackChannelConduit(response);
    }

    @Override
    protected final boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        partialResponse.put(Message.RESPONSE_CODE, 202);
        partialResponse.getExchange().put(EndpointReferenceType.class, decoupledTarget);
        partialResponse.put(PARTIAL_RESPONSE, Boolean.TRUE);
        return true;
    }

    protected boolean isPartialResponse(Message m) {
        return Boolean.TRUE.equals(m.get(PARTIAL_RESPONSE));
    }

    private void initConfig() {
        PolicyEngine engine = this.bus.getExtension(PolicyEngine.class);
        if (null != engine && engine.isEnabled() && null != this.endpointInfo.getService()) {
            this.server = PolicyUtils.getServer(engine, this.endpointInfo, this);
        }
        if (null == this.server) {
            this.server = this.endpointInfo.getTraversedExtensor(new HTTPServerPolicy(), HTTPServerPolicy.class);
        }
    }

    private static List<String> createMutableList(String val) {
        return new ArrayList<String>(Arrays.asList(val));
    }

    void setPolicies(Map<String, List<String>> headers) {
        HTTPServerPolicy policy = this.server;
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", AbstractHTTPDestination.createMutableList(policy.getCacheControl().value()));
        }
        if (policy.isSetContentLocation()) {
            headers.put("Content-Location", AbstractHTTPDestination.createMutableList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            headers.put("Content-Encoding", AbstractHTTPDestination.createMutableList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", AbstractHTTPDestination.createMutableList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            headers.put("Server", AbstractHTTPDestination.createMutableList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            headers.put("Connection", AbstractHTTPDestination.createMutableList("close"));
        } else if (policy.isSetKeepAliveParameters()) {
            headers.put("Keep-Alive", AbstractHTTPDestination.createMutableList(policy.getKeepAliveParameters()));
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        this.updateResponseHeaders(outMessage);
        Object responseObj = outMessage.get(HTTP_RESPONSE);
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        if (responseObj instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)responseObj;
            Integer i = (Integer)outMessage.get(Message.RESPONSE_CODE);
            if (i != null) {
                Map pHeaders;
                int status = i;
                if (500 == i && null != (pHeaders = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS))) && pHeaders.containsKey(PROTOCOL_HEADERS_CONTENT_TYPE)) {
                    pHeaders.remove(PROTOCOL_HEADERS_CONTENT_TYPE);
                }
                response.setStatus(status);
            } else if (oneWay) {
                response.setStatus(202);
            } else {
                response.setStatus(200);
            }
            this.copyResponseHeaders(outMessage, response);
            if (oneWay && !this.isPartialResponse(outMessage)) {
                response.setContentLength(0);
                response.flushBuffer();
                response.getOutputStream().close();
            } else {
                responseStream = response.getOutputStream();
            }
        } else {
            if (null != responseObj) {
                String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, responseObj.getClass()).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        if (oneWay) {
            outMessage.remove(HTTP_RESPONSE);
        }
        return responseStream;
    }

    protected boolean contextMatchOnExact() {
        return "exact".equals(this.contextMatchStrategy);
    }

    @Override
    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    @Override
    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress(this.reference);
            ref = EndpointReferenceUtils.duplicate(this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress(ref, address + id);
            } else {
                EndpointReferenceUtils.setAddress(ref, address + "/" + id);
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        return ref;
    }

    @Override
    public String getId(Map context) {
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            return super.getId(context);
        }
        return id;
    }

    public String getContextMatchStrategy() {
        return this.contextMatchStrategy;
    }

    public void setContextMatchStrategy(String contextMatchStrategy) {
        this.contextMatchStrategy = contextMatchStrategy;
    }

    public boolean isFixedParameterOrder() {
        return this.fixedParameterOrder;
    }

    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        this.fixedParameterOrder = fixedParameterOrder;
    }

    public boolean isMultiplexWithAddress() {
        return this.multiplexWithAddress;
    }

    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        this.multiplexWithAddress = multiplexWithAddress;
    }

    public HTTPServerPolicy getServer() {
        return this.server;
    }

    public void setServer(HTTPServerPolicy server) {
        this.server = server;
    }

    @Override
    public void assertMessage(Message message) {
        PolicyUtils.assertServerPolicy(message, this.server);
    }

    @Override
    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPSERVERPOLICY_ASSERTION_QNAME.equals(type);
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage))) {
                this.wrappedStream = responseStream;
            }
            if (this.wrappedStream != null) {
                this.wrappedStream.close();
                this.response.flushBuffer();
            }
        }

        public void flush() throws IOException {
        }
    }

    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;

        BackChannelConduit(HttpServletResponse resp) {
            super(AbstractHTTPDestination.this);
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put(AbstractHTTPDestination.HTTP_RESPONSE, this.response);
            message.setContent(OutputStream.class, new WrappedOutputStream(message, this.response));
        }
    }
}

