/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.schema_validation;

import java.net.URL;

import javax.xml.ws.Endpoint;

import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class ValidationServer extends AbstractBusTestServerBase {
    public static final String PORT = allocatePort(ValidationServer.class);

    private String oldConfig;

    public ValidationServer() {
        oldConfig = System.getProperty("cxf.config.file.url");
        URL url = getClass().getResource("cxf-config.xml");
        if (url != null) {
            System.setProperty("cxf.config.file.url", url.toString());
        }
    }

    protected void run() {
        Object implementor = new SchemaValidationImpl();
        String address = "http://localhost:" + PORT + "/SoapContext/SoapPort";
        Endpoint.publish(address, implementor);
    }

    public boolean stopInProcess() throws Exception {
        if (oldConfig != null) {
            System.setProperty("cxf.config.file.url", oldConfig);
        }
        return super.stopInProcess();
    }

    public static void main(String[] args) {
        try {
            ValidationServer s = new ValidationServer();
            s.start();
        } catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        } finally {
            System.out.println("done!");
        }
    }
}
