/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.UserResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSClientFactory {
    private JAXRSClientFactory() {
    }

    public static <T> T create(String baseAddress, Class<T> cls) {
        return JAXRSClientFactory.create(URI.create(baseAddress), cls);
    }

    public static <T> T create(URI baseURI, Class<T> cls) {
        return JAXRSClientFactory.create(baseURI, cls, false);
    }

    public static <T> T create(URI baseURI, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseURI.toString(), cls, null);
        bean.setInheritHeaders(inheritHeaders);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation, Object ... varValues) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, varValues);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, null);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean.setProviders(providers);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setProviders(providers);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelRef, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setModelRef(modelRef);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        bean.setModelRef(modelRef);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelBeans, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setModelBeans(modelBeans);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T fromClient(Client client, Class<T> cls) {
        return JAXRSClientFactory.fromClient(client, cls, false);
    }

    public static <T> T fromClient(Client client, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(client.getCurrentURI().toString(), cls, null);
        bean.setInheritHeaders(inheritHeaders);
        ClientState clientState = WebClient.getClientState(client);
        T proxy = null;
        if (clientState == null) {
            proxy = bean.create(cls, new Object[0]);
            if (inheritHeaders) {
                WebClient.client(proxy).headers(client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            bean.setInitialState(clientState.newState(client.getCurrentURI(), headers, null));
            proxy = bean.create(cls, new Object[0]);
        }
        WebClient.copyProperties(WebClient.client(proxy), client);
        return proxy;
    }

    static <T> T create(Class<T> cls, InvocationHandler handler) {
        return cls.cast(ProxyHelper.getProxy(cls.getClassLoader(), new Class[]{cls, Client.class}, handler));
    }

    private static JAXRSClientFactoryBean getBean(String baseAddress, Class<?> cls, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setServiceClass(cls);
        return bean;
    }
}

