/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class EncryptionToken
extends TokenWrapper {
    public EncryptionToken(SPConstants version) {
        super(version);
    }

    public Token getEncryptionToken() {
        return this.getToken();
    }

    public void setEncryptionToken(Token encryptionToken) {
        this.setToken(encryptionToken);
    }

    public QName getRealName() {
        return this.constants.getEncryptionToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getEncryptionToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String wspNamespaceURI;
        String wspWriterPrefix;
        String prefix;
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((wspWriterPrefix = writer.getPrefix(wspNamespaceURI = SPConstants.POLICY.getNamespaceURI())) == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, wspNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, SPConstants.POLICY.getLocalPart(), wspNamespaceURI);
        if (wspWriterPrefix == null) {
            writer.writeNamespace(wspPrefix, wspNamespaceURI);
        }
        if (this.token == null) {
            throw new RuntimeException("EncryptionToken is not set");
        }
        this.token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

