/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.workqueue.WorkQueueManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayProcessorInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String USE_ORIGINAL_THREAD = OneWayProcessorInterceptor.class.getName() + ".USE_ORIGINAL_THREAD";

    public OneWayProcessorInterceptor() {
        super("pre-logical");
    }

    public OneWayProcessorInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        if (message.getExchange().isOneWay() && !this.isRequestor(message) && message.get(OneWayProcessorInterceptor.class) == null && message.getExchange().get(Executor.class) == null) {
            message.put(OneWayProcessorInterceptor.class, (Object)this);
            final InterceptorChain chain = message.getInterceptorChain();
            try {
                Message partial = OneWayProcessorInterceptor.createMessage(message.getExchange());
                partial.setExchange(message.getExchange());
                Conduit conduit = message.getExchange().getDestination().getBackChannel(message, null, null);
                conduit.prepare(partial);
                conduit.close(partial);
            }
            catch (IOException e) {
                // empty catch block
            }
            Object o = message.getContextualProperty(USE_ORIGINAL_THREAD);
            if (o == null) {
                o = Boolean.FALSE;
            } else if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            if (Boolean.FALSE.equals(o)) {
                chain.pause();
                try {
                    ((WorkQueueManager)((Bus)message.getExchange().get(Bus.class)).getExtension(WorkQueueManager.class)).getAutomaticWorkQueue().execute(new Runnable(){

                        public void run() {
                            chain.resume();
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    chain.resume();
                }
            }
        }
    }

    private static Message createMessage(Exchange exchange) {
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        Message msg = null;
        if (ep != null) {
            msg = ep.getBinding().createMessage();
        }
        return msg;
    }
}

