/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/atom+xml", "application/atom+xml;type=feed", "application/json"})
@Consumes(value={"application/atom+xml", "application/atom+xml;type=feed"})
@Provider
public class AtomFeedProvider
implements MessageBodyWriter<Feed>,
MessageBodyReader<Feed> {
    private static final String JSON_TYPE = "application/json";
    private static final Abdera ATOM_ENGINE = new Abdera();

    public long getSize(Feed feed, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Feed.class.isAssignableFrom(type);
    }

    public void writeTo(Feed feed, Class<?> clazz, Type type, Annotation[] a, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (JSON_TYPE.equals(mt.toString())) {
            Writer w = ATOM_ENGINE.getWriterFactory().getWriter("json");
            feed.writeTo(w, os);
        } else {
            feed.writeTo(os);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Feed.class.isAssignableFrom(type);
    }

    public Feed readFrom(Class<Feed> clazz, Type t, Annotation[] a, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        Document doc = ATOM_ENGINE.getParser().parse(is);
        return (Feed)doc.getRoot();
    }
}

