/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.RequiredParts;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPartsBuilder
implements AssertionBuilder {
    @Override
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        RequiredParts requiredParts = new RequiredParts(SP12Constants.INSTANCE);
        for (Node nd = element.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (!(nd instanceof Element)) continue;
            this.processElement((Element)nd, requiredParts);
        }
        return requiredParts;
    }

    public List<QName> getKnownElements() {
        return Collections.singletonList(SP12Constants.REQUIRED_PARTS);
    }

    private void processElement(Element element, RequiredParts parent) {
        if ("Header".equals(element.getLocalName())) {
            String nameAttribute = element.getAttribute("Name");
            if (nameAttribute == null) {
                nameAttribute = "";
            }
            String namespaceAttribute = element.getAttribute("Namespace");
            parent.addHeader(new Header(nameAttribute, namespaceAttribute));
        }
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

