/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils.schemas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(SchemaHandler.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private Schema schema;

    public void setSchemas(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema createSchema(List<String> locations) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = null;
        try {
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            for (String loc : locations) {
                InputStream is = null;
                if (loc.startsWith(CLASSPATH_PREFIX)) {
                    String path = loc.substring(CLASSPATH_PREFIX.length());
                    is = ClassLoaderUtils.getResourceAsStream((String)path, SchemaHandler.class);
                    if (is == null) {
                        LOG.warning("No schema resource " + loc + " is available on classpath");
                        return null;
                    }
                } else {
                    File f = new File(loc);
                    if (!f.exists()) {
                        LOG.warning("No schema resource " + loc + " is available on local disk");
                        return null;
                    }
                    is = new FileInputStream(f);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                sources.add(new StreamSource(r));
            }
            s = factory.newSchema(sources.toArray(new Source[0]));
        }
        catch (Exception ex) {
            LOG.warning("Validation will be disabled, failed to create schema : " + ex.getMessage());
        }
        return s;
    }
}

