/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSServiceFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";

    public Object invoke(Exchange exchange, Object request) {
        Response response = (Response)exchange.get(Response.class);
        if (response != null) {
            return new MessageContentsList(new Object[]{response});
        }
        return this.invoke(exchange, request, this.getServiceObject(exchange));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        this.pushOntoStack(ori, ClassHelper.getRealClass((Object)resourceObject), exchange.getInMessage());
        Method methodToInvoke = InjectionUtils.checkProxy(cri.getMethodDispatcher().getMethod(ori), resourceObject);
        if (cri.isRoot()) {
            JAXRSUtils.handleSetters(ori, resourceObject, exchange.getInMessage());
            InjectionUtils.injectContextFields(resourceObject, ori.getClassResourceInfo(), exchange.getInMessage());
            InjectionUtils.injectResourceFields(resourceObject, ori.getClassResourceInfo(), exchange.getInMessage());
        }
        List params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        Object result = null;
        ClassLoader contextLoader = null;
        try {
            if (this.setServiceLoaderAsContextLoader(exchange.getInMessage())) {
                contextLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(resourceObject.getClass().getClassLoader());
            }
            result = this.invoke(exchange, resourceObject, methodToInvoke, params);
            if (contextLoader != null) {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        catch (Fault ex) {
            try {
                Response excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause(), exchange.getInMessage());
                if (excResponse == null) {
                    ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
                    ClassResourceInfo criRoot = (ClassResourceInfo)exchange.get((Object)"root.resource.class");
                    if (criRoot != null) {
                        criRoot.clearThreadLocalProxies();
                    }
                    exchange.put((Object)Message.PROPOGATE_EXCEPTION, (Object)Boolean.TRUE);
                    throw ex;
                }
                MessageContentsList criRoot = new MessageContentsList(new Object[]{excResponse});
                if (contextLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextLoader);
                }
                return criRoot;
            }
            catch (Throwable throwable) {
                if (contextLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextLoader);
                }
                throw throwable;
            }
        }
        if (ori.isSubResourceLocator()) {
            try {
                Message msg = exchange.getInMessage();
                MultivaluedMap values = this.getTemplateValues(msg);
                String subResourcePath = (String)msg.get((Object)"relative.path");
                String httpMethod = (String)msg.get((Object)Message.HTTP_REQUEST_METHOD);
                String contentType = (String)msg.get((Object)"Content-Type");
                if (contentType == null) {
                    contentType = "*/*";
                }
                List acceptContentType = (List)msg.getExchange().get((Object)"Accept");
                result = JAXRSInvoker.checkResultObject(result, subResourcePath);
                ClassResourceInfo subCri = cri.getSubResource(methodToInvoke.getReturnType(), ClassHelper.getRealClass((Object)result));
                if (subCri == null) {
                    org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, new Object[]{subResourcePath});
                    LOG.severe(errorM.toString());
                    throw new WebApplicationException(404);
                }
                OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(subCri, subResourcePath, httpMethod, (MultivaluedMap<String, String>)values, contentType, acceptContentType);
                exchange.put(OperationResourceInfo.class, (Object)subOri);
                msg.put((Object)"relative.path", values.getFirst((Object)"FINAL_MATCH_GROUP"));
                msg.put((Object)"jaxrs.template.parameters", (Object)values);
                List<Object> newParams = JAXRSUtils.processParameters(subOri, (MultivaluedMap<String, String>)values, msg);
                msg.setContent(List.class, newParams);
                return this.invoke(exchange, newParams, result);
            }
            catch (WebApplicationException ex) {
                Response excResponse = JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
                return new MessageContentsList(new Object[]{excResponse});
            }
        }
        return result;
    }

    protected MultivaluedMap getTemplateValues(Message msg) {
        MetadataMap values = new MetadataMap();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll((Map)oldValues);
        }
        return values;
    }

    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    public Object getServiceObject(Exchange exchange) {
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        return cri.getResourceProvider().getInstance(exchange.getInMessage());
    }

    private static Object checkResultObject(Object result, String subResourcePath) {
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        if (result == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, new Object[]{subResourcePath});
            LOG.info(errorM.toString());
            throw new WebApplicationException(404);
        }
        return result;
    }

    private void pushOntoStack(OperationResourceInfo ori, Class<?> realClass, Message msg) {
        OperationResourceInfoStack stack = (OperationResourceInfoStack)msg.get(OperationResourceInfoStack.class);
        if (stack == null) {
            stack = new OperationResourceInfoStack();
            msg.put(OperationResourceInfoStack.class, (Object)stack);
        }
        MultivaluedMap params = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        List<String> values = null;
        if (params == null || params.size() == 1) {
            values = Collections.emptyList();
        } else {
            values = new ArrayList<String>(params.size() - 1);
            for (Parameter pm : ori.getParameters()) {
                List paramValues;
                if (pm.getType() != ParameterType.PATH || (paramValues = (List)params.get((Object)pm.getName())) == null) continue;
                values.addAll(paramValues);
            }
        }
        stack.push(new MethodInvocationInfo(ori, realClass, values));
    }
}

