/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.FormValidator;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
@Provider
public class FormEncodingProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<MultivaluedMap<String, String>> {
    private FormValidator validator;
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public void setValidator(FormValidator formValidator) {
        this.validator = formValidator;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return MultivaluedMap.class.isAssignableFrom(type) || mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE) && MultipartBody.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            if (MultipartBody.class.isAssignableFrom(clazz)) {
                return AttachmentUtils.getMultipartBody(this.mc);
            }
            MultivaluedMap<String, String> params = this.createMap(clazz);
            this.populateMap(params, is, type, AnnotationUtils.getAnnotation(annotations, Encoded.class) == null);
            this.validateMap(params);
            return params;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected MultivaluedMap<String, String> createMap(Class<?> clazz) throws Exception {
        if (clazz == MultivaluedMap.class) {
            return new MetadataMap<String, String>();
        }
        return (MultivaluedMap)clazz.newInstance();
    }

    protected void populateMap(MultivaluedMap<String, String> params, InputStream is, MediaType mt, boolean decode) {
        if (mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            MultipartBody body = AttachmentUtils.getMultipartBody(this.mc, this.attachmentDir, this.attachmentThreshold);
            FormUtils.populateMapFromMultipart(params, body, decode);
        } else {
            FormUtils.populateMapFromString(params, FormUtils.readBody(is), decode);
        }
    }

    protected void validateMap(MultivaluedMap<String, String> params) {
        if (this.validator != null) {
            this.validator.validate(params);
        }
    }

    public long getSize(MultivaluedMap<String, String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    public void writeTo(MultivaluedMap<String, String> map, Class<?> c, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        boolean encoded = AnnotationUtils.getAnnotation(anns, Encoded.class) != null;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Iterator entryIterator = ((List)entry.getValue()).iterator();
            while (entryIterator.hasNext()) {
                String value = (String)entryIterator.next();
                os.write(((String)entry.getKey()).getBytes("UTF-8"));
                os.write(61);
                String data = encoded ? value : HttpUtils.urlEncode(value);
                os.write(data.getBytes("UTF-8"));
                if (!entryIterator.hasNext() && !it.hasNext()) continue;
                os.write(38);
            }
        }
    }
}

