/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider
extends AbstractJAXBProvider {
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private Map<String, String> wrapperMap;

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType);
            InputStream realStream = this.getInputStream(type, genericType, is);
            MappedXMLInputFactory factory = new MappedXMLInputFactory(this.namespaceMap);
            XMLStreamReader xsw = factory.createXMLStreamReader(realStream);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal(xsw, theType) : unmarshaller.unmarshal(xsw);
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    protected InputStream getInputStream(Class<Object> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            ByteArrayInputStream isAfter = new ByteArrayInputStream("}".getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<Object> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null, false)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw new WebApplicationException(500);
        }
        return "{\"" + name + "\":";
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding;
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> actualClass = actualObject.getClass();
            if (cls == genericType) {
                genericType = actualClass;
            }
            if ((encoding = this.getEncoding(m, headers)) == null) {
                encoding = "UTF-8";
            }
            Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, encoding);
            QName qname = this.getQName(actualClass, genericType, actualObject, true);
            Configuration c = new Configuration(this.namespaceMap);
            MappedNamespaceConvention convention = new MappedNamespaceConvention(c);
            MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, encoding));
            if (this.serializeAsArray) {
                if (this.arrayKeys != null) {
                    for (String key : this.arrayKeys) {
                        xsw.seriliazeAsArray(key);
                    }
                } else {
                    String key = this.getKey(convention, qname);
                    xsw.seriliazeAsArray(key);
                }
            }
            ms.marshal(actualObject, (XMLStreamWriter)xsw);
            xsw.close();
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    private QName getQName(Class<?> cls, Type type, Object object, boolean allocatePrefix) throws Exception {
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        QName qname = null;
        if (root != null) {
            String namespace = this.getNamespace(root.namespace());
            String name = this.getLocalName(root.name(), cls.getSimpleName());
            String prefix = this.getPrefix(namespace, allocatePrefix);
            qname = new QName(namespace, name, prefix);
        } else {
            JAXBContext context = this.getJAXBContext(cls, type);
            JAXBContextProxy proxy = ReflectionInvokationHandler.createProxyWrapper(context, JAXBContextProxy.class);
            JAXBBeanInfo info = JAXBUtils.getBeanInfo(proxy, cls);
            if (info != null) {
                try {
                    Object instance = object == null ? cls.newInstance() : object;
                    String name = this.getLocalName(info.getElementLocalName(instance), cls.getSimpleName());
                    String namespace = this.getNamespace(info.getElementNamespaceURI(instance));
                    String prefix = this.getPrefix(namespace, allocatePrefix);
                    qname = new QName(namespace, name, prefix);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return qname;
    }

    private String getLocalName(String name, String clsName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        return name;
    }

    private String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }

    private String getPrefix(String namespace, boolean allocatePrefix) {
        String prefix = this.namespaceMap.get(namespace);
        if (prefix == null) {
            if (allocatePrefix && namespace.length() > 0) {
                prefix = "ns" + (this.namespaceMap.size() + 1);
                this.namespaceMap.put(namespace, prefix);
            } else {
                prefix = "";
            }
        }
        return prefix;
    }
}

