/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxb.NamespaceMapper;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
@Provider
public class JAXBElementProvider
extends AbstractJAXBProvider {
    private static final List<String> MARSHALLER_PROPERTIES = Arrays.asList("jaxb.encoding", "jaxb.formatted.output", "jaxb.fragment", "jaxb.noNamespaceSchemaLocation", "jaxb.schemaLocation");
    private Map<String, Object> mProperties = new HashMap<String, Object>();
    private boolean enableStreaming;
    private ValidationEventHandler eventHandler;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.isSupported(type, genericType, anns);
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setValidationHandler(ValidationEventHandler handler) {
        this.eventHandler = handler;
    }

    public void setEnableStreaming(boolean enableStream) {
        this.enableStreaming = enableStream;
    }

    public boolean getEnableStreaming() {
        return this.enableStreaming;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setMarshallerProperties(Map<String, Object> marshallProperties) {
        this.mProperties = marshallProperties;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.mProperties.put("jaxb.schemaLocation", schemaLocation);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            Class<Object> theType = isCollection ? InjectionUtils.getActualType(genericType) : type;
            theType = this.getActualType(theType, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType, isCollection);
            if (this.eventHandler != null) {
                unmarshaller.setEventHandler(this.eventHandler);
            }
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal((Source)new StreamSource(is), theType) : this.doUnmarshal(unmarshaller, type, is, mt);
            if (isCollection) {
                response = ((AbstractJAXBProvider.CollectionWrapper)response).getCollectionOrArray(theType, type);
            }
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    protected Object doUnmarshal(Unmarshaller unmarshaller, Class<?> type, InputStream is, MediaType mt) throws JAXBException {
        XMLStreamReader reader = this.getStreamReader(is, type, mt);
        if (reader != null) {
            return this.unmarshalFromReader(unmarshaller, reader, mt);
        }
        return this.unmarshalFromInputStream(unmarshaller, is, mt);
    }

    protected XMLStreamReader getStreamReader(InputStream is, Class<?> type, MediaType mt) {
        XMLStreamReader reader;
        MessageContext mc = this.getContext();
        XMLStreamReader xMLStreamReader = reader = mc != null ? mc.getContent(XMLStreamReader.class) : null;
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            reader = reader == null ? StaxUtils.createXMLStreamReader(is) : reader;
            return new JAXBCollectionWrapperReader(reader);
        }
        return reader;
    }

    protected Object unmarshalFromInputStream(Unmarshaller unmarshaller, InputStream is, MediaType mt) throws JAXBException {
        return unmarshaller.unmarshal(is);
    }

    protected Object unmarshalFromReader(Unmarshaller unmarshaller, XMLStreamReader reader, MediaType mt) throws JAXBException {
        return unmarshaller.unmarshal(reader);
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> actualClass = obj != actualObject ? actualObject.getClass() : cls;
            String encoding = this.getEncoding(m, headers);
            if (InjectionUtils.isSupportedCollectionOrArray(actualClass)) {
                actualClass = InjectionUtils.getActualType(genericType);
                this.marshalCollection(cls, actualObject, actualClass, genericType, encoding, os, m);
            } else {
                this.marshal(actualObject, actualClass, genericType, encoding, os, m);
            }
        }
        catch (JAXBException e) {
            JAXBElementProvider.handleJAXBException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void marshalCollection(Class<?> originalCls, Object actualObject, Class<?> actualClass, Type genericType, String encoding, OutputStream os, MediaType m) throws Exception {
        Object[] arr = originalCls.isArray() ? (Object[])actualObject : ((Collection)actualObject).toArray();
        QName qname = null;
        if (arr.length > 0 && arr[0] instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)arr[0];
            qname = el.getName();
            actualClass = el.getDeclaredType();
        } else {
            qname = this.getCollectionWrapperQName(actualClass, genericType, actualObject, true);
        }
        if (qname == null) {
            String message = new Message("NO_COLLECTION_ROOT", BUNDLE, new Object[0]).toString();
            throw new WebApplicationException(Response.serverError().entity((Object)message).build());
        }
        String startTag = null;
        String endTag = null;
        if (qname.getNamespaceURI().length() > 0) {
            startTag = "<ns1:" + qname.getLocalPart() + " xmlns:ns1=\"" + qname.getNamespaceURI() + "\">";
            endTag = "</ns1:" + qname.getLocalPart() + ">";
        } else {
            startTag = "<" + qname.getLocalPart() + ">";
            endTag = "</" + qname.getLocalPart() + ">";
        }
        os.write(startTag.getBytes());
        for (Object o : arr) {
            this.marshalCollectionMember(o instanceof JAXBElement ? ((JAXBElement)o).getValue() : o, actualClass, genericType, encoding, os, m, qname.getNamespaceURI());
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, String ns) throws Exception {
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        ms.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        if (ns.length() > 0) {
            Map<String, String> map = Collections.singletonMap(ns, "ns1");
            NamespaceMapper nsMapper = new NamespaceMapper(map);
            try {
                ms.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)nsMapper);
            }
            catch (PropertyException ex) {
                ms.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)nsMapper);
            }
        }
        this.marshal(obj, cls, genericType, enc, os, mt, ms);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt) throws Exception {
        if ((obj = this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        this.marshal(obj, cls, genericType, enc, os, mt, ms);
    }

    protected void marshal(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os, MediaType mt, Marshaller ms) throws Exception {
        XMLStreamWriter writer;
        for (Map.Entry<String, Object> entry : this.mProperties.entrySet()) {
            ms.setProperty(entry.getKey(), entry.getValue());
        }
        MessageContext mc = this.getContext();
        if (mc != null) {
            for (String key : MARSHALLER_PROPERTIES) {
                Object value = mc.get(key);
                if (value == null) continue;
                ms.setProperty(key, value);
            }
        }
        if ((writer = this.getStreamWriter(obj, os, mt)) != null) {
            if (mc != null) {
                mc.put(XMLStreamWriter.class.getName(), writer);
            }
            this.marshalToWriter(ms, obj, writer, mt);
        } else {
            this.marshalToOutputStream(ms, obj, os, mt);
        }
    }

    protected XMLStreamWriter getStreamWriter(Object obj, OutputStream os, MediaType mt) {
        XMLStreamWriter writer = null;
        MessageContext mc = this.getContext();
        if (mc != null && (writer = mc.getContent(XMLStreamWriter.class)) == null && this.enableStreaming) {
            writer = StaxUtils.createXMLStreamWriter(os);
        }
        return writer;
    }

    protected void marshalToOutputStream(Marshaller ms, Object obj, OutputStream os, MediaType mt) throws Exception {
        ms.marshal(obj, os);
    }

    protected void marshalToWriter(Marshaller ms, Object obj, XMLStreamWriter writer, MediaType mt) throws Exception {
        ms.marshal(obj, writer);
    }

    protected static class JAXBCollectionWrapperReader
    extends DepthXMLStreamReader {
        private boolean firstName;
        private boolean firstNs;

        public JAXBCollectionWrapperReader(XMLStreamReader reader) {
            super(reader);
        }

        public String getNamespaceURI() {
            if (!this.firstNs) {
                this.firstNs = true;
                return "";
            }
            return super.getNamespaceURI();
        }

        public String getLocalName() {
            if (!this.firstName) {
                this.firstName = true;
                return "collectionWrapper";
            }
            return super.getLocalName();
        }
    }
}

