/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.trust.TrustException;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSClient
implements Configurable {
    private static final Logger LOG = LogUtils.getL7dLogger(STSClient.class);
    Bus bus;
    String name = "default.sts-client";
    Client client;
    String location;
    String wsdlLocation;
    QName serviceName;
    QName endpointName;
    Policy policy;
    String soapVersion = "http://schemas.xmlsoap.org/soap/";
    int keySize = 256;
    boolean requiresEntropy = true;
    Element template;
    AlgorithmSuite algorithmSuite;
    String namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    String addressingNamespace;
    boolean isSecureConv;
    int ttl = 300;
    Map<String, Object> ctx = new HashMap<String, Object>();

    public STSClient(Bus b) {
        this.bus = b;
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    public void setBeanName(String s) {
        this.name = s;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
        if (this.algorithmSuite == null) {
            Iterator i = policy.getAlternatives();
            while (i.hasNext() && this.algorithmSuite == null) {
                List<PolicyComponent> p = CastUtils.cast((List)i.next());
                for (PolicyComponent p2 : p) {
                    if (!(p2 instanceof Binding)) continue;
                    this.algorithmSuite = ((Binding)p2).getAlgorithmSuite();
                }
            }
        }
    }

    public void setPolicy(Element policy) {
        this.setPolicy(this.bus.getExtension(PolicyBuilder.class).getPolicy(policy));
    }

    public void setSoap12() {
        this.soapVersion = "http://schemas.xmlsoap.org/wsdl/soap12/";
    }

    public void setSoap11() {
        this.soapVersion = "http://schemas.xmlsoap.org/soap/";
    }

    public void setSoap11(boolean b) {
        if (b) {
            this.setSoap11();
        } else {
            this.setSoap12();
        }
    }

    public void setAddressingNamespace(String ad) {
        this.addressingNamespace = ad;
    }

    public void setTrust(Trust10 trust) {
        if (trust != null) {
            this.namespace = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            this.requiresEntropy = trust.isRequireClientEntropy();
        }
    }

    public void setTrust(Trust13 trust) {
        if (trust != null) {
            this.namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            this.requiresEntropy = trust.isRequireClientEntropy();
        }
    }

    public boolean isRequiresEntropy() {
        return this.requiresEntropy;
    }

    public void setRequiresEntropy(boolean requiresEntropy) {
        this.requiresEntropy = requiresEntropy;
    }

    public boolean isSecureConv() {
        return this.isSecureConv;
    }

    public void setSecureConv(boolean secureConv) {
        this.isSecureConv = secureConv;
    }

    public void setAlgorithmSuite(AlgorithmSuite ag) {
        this.algorithmSuite = ag;
    }

    public Map<String, Object> getRequestContext() {
        return this.ctx;
    }

    public void setProperties(Map<String, Object> p) {
        this.ctx.putAll(p);
    }

    public Map<String, Object> getProperties() {
        return this.ctx;
    }

    public void setWsdlLocation(String wsdl) {
        this.wsdlLocation = wsdl;
    }

    public void setServiceName(String qn) {
        this.serviceName = QName.valueOf(qn);
    }

    public void setEndpointName(String qn) {
        this.endpointName = QName.valueOf(qn);
    }

    public void setServiceQName(QName qn) {
        this.serviceName = qn;
    }

    public void setEndpointQName(QName qn) {
        this.endpointName = qn;
    }

    private void createClient() throws BusException, EndpointException {
        if (this.client != null) {
            return;
        }
        this.bus.getExtension(Configurer.class).configureBean(this.name, this);
        if (this.wsdlLocation != null) {
            WSDLServiceFactory factory = new WSDLServiceFactory(this.bus, this.wsdlLocation, this.serviceName);
            SourceDataBinding dataBinding = new SourceDataBinding();
            factory.setDataBinding(dataBinding);
            Service service = factory.create();
            service.setDataBinding(dataBinding);
            EndpointInfo ei = service.getEndpointInfo(this.endpointName);
            EndpointImpl endpoint = new EndpointImpl(this.bus, service, ei);
            this.client = new ClientImpl(this.bus, endpoint);
        } else {
            Endpoint endpoint = STSUtils.createSTSEndpoint(this.bus, this.namespace, null, this.location, this.soapVersion, this.policy, this.endpointName);
            this.client = new ClientImpl(this.bus, endpoint);
        }
    }

    private BindingOperationInfo findOperation(String suffix) {
        BindingInfo bi = this.client.getEndpoint().getBinding().getBindingInfo();
        for (BindingOperationInfo boi : bi.getOperations()) {
            SoapOperationInfo soi = boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || soi.getAction() == null || !soi.getAction().endsWith(suffix)) continue;
            PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
            Conduit conduit = this.client.getConduit();
            EffectivePolicy effectivePolicy = pe.getEffectiveClientRequestPolicy(this.client.getEndpoint().getEndpointInfo(), boi, conduit);
            this.setPolicy(effectivePolicy.getPolicy());
            return boi;
        }
        return null;
    }

    public SecurityToken requestSecurityToken() throws Exception {
        return this.requestSecurityToken(null);
    }

    public SecurityToken requestSecurityToken(String appliesTo) throws Exception {
        String action = null;
        if (this.isSecureConv) {
            action = this.namespace + "/RST/SCT";
        }
        return this.requestSecurityToken(appliesTo, action, "/Issue", null);
    }

    public SecurityToken requestSecurityToken(String appliesTo, String action, String requestType, SecurityToken target) throws Exception {
        this.createClient();
        BindingOperationInfo boi = this.findOperation("/RST/Issue");
        this.client.getRequestContext().putAll(this.ctx);
        if (action != null) {
            this.client.getRequestContext().put("SOAPAction", action);
        }
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        boolean wroteKeySize = false;
        String keyType = null;
        if (this.template != null) {
            Element tl = DOMUtils.getFirstElement(this.template);
            while (tl != null) {
                StaxUtils.copy(tl, (XMLStreamWriter)writer);
                if ("KeyType".equals(tl.getLocalName())) {
                    keyType = DOMUtils.getContent(tl);
                } else if ("KeySize".equals(tl.getLocalName())) {
                    wroteKeySize = true;
                    this.keySize = Integer.parseInt(DOMUtils.getContent(tl));
                }
                tl = DOMUtils.getNextElement(tl);
            }
        }
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + requestType);
        writer.writeEndElement();
        this.addAppliesTo(writer, appliesTo);
        keyType = this.writeKeyType(writer, keyType);
        byte[] requestorEntropy = null;
        X509Certificate cert = null;
        Crypto crypto = null;
        if (keyType.endsWith("SymmetricKey")) {
            if (!wroteKeySize && !this.isSecureConv) {
                writer.writeStartElement("wst", "KeySize", this.namespace);
                writer.writeCharacters(Integer.toString(this.keySize));
                writer.writeEndElement();
            }
            if (this.requiresEntropy) {
                writer.writeStartElement("wst", "Entropy", this.namespace);
                writer.writeStartElement("wst", "BinarySecret", this.namespace);
                writer.writeAttribute("Type", this.namespace + "/Nonce");
                requestorEntropy = WSSecurityUtil.generateNonce((int)(this.algorithmSuite.getMaximumSymmetricKeyLength() / 8));
                writer.writeCharacters(Base64.encode((byte[])requestorEntropy));
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeStartElement("wst", "ComputedKeyAlgorithm", this.namespace);
                writer.writeCharacters(this.namespace + "/CK/PSHA1");
                writer.writeEndElement();
            }
        } else if (keyType.endsWith("PublicKey")) {
            writer.writeStartElement("wst", "UseKey", this.namespace);
            writer.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
            writer.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            crypto = this.createCrypto(false);
            cert = this.getCert(crypto);
            PublicKey key = cert.getPublicKey();
            String pubKeyAlgo = key.getAlgorithm();
            if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
                DSAKeyValue dsaKeyValue = new DSAKeyValue(writer.getDocument(), (Key)key);
                writer.getCurrentNode().appendChild(dsaKeyValue.getElement());
            } else if ("RSA".equalsIgnoreCase(pubKeyAlgo)) {
                RSAKeyValue rsaKeyValue = new RSAKeyValue(writer.getDocument(), (Key)key);
                writer.getCurrentNode().appendChild(rsaKeyValue.getElement());
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (target != null) {
            writer.writeStartElement("wst", "RenewTarget", this.namespace);
            Element el = target.getUnattachedReference();
            if (el == null) {
                el = target.getAttachedReference();
            }
            StaxUtils.copy(el, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        Object[] obj = this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
        SecurityToken token = this.createSecurityToken(this.getDocumentElement((DOMSource)obj[0]), requestorEntropy);
        if (cert != null) {
            token.setX509Certificate(cert, crypto);
        }
        return token;
    }

    private Element getDocumentElement(DOMSource ds) {
        Node nd = ds.getNode();
        if (nd instanceof Document) {
            nd = ((Document)nd).getDocumentElement();
        }
        return (Element)nd;
    }

    public void renewSecurityToken(SecurityToken tok) throws Exception {
        String action = null;
        if (this.isSecureConv) {
            action = this.namespace + "/RST/SCT/Renew";
        }
        this.requestSecurityToken(tok.getIssuerAddress(), action, "/Renew", tok);
    }

    private PrimitiveAssertion getAddressingAssertion() {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing/policy";
        return new PrimitiveAssertion(new QName(ns, "UsingAddressing"));
    }

    public boolean validateSecurityToken(SecurityToken tok) throws Exception {
        return this.validateSecurityToken(tok, this.namespace + "/RSTR/Status");
    }

    private boolean validateSecurityToken(SecurityToken tok, String string) throws Exception {
        this.createClient();
        if (this.addressingNamespace == null) {
            this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        Policy validatePolicy = new Policy();
        ExactlyOne one = new ExactlyOne();
        validatePolicy.addPolicyComponent((PolicyComponent)one);
        All all = new All();
        SymmetricBinding binding = new SymmetricBinding();
        all.addAssertion((Assertion)binding);
        one.addPolicyComponent((PolicyComponent)all);
        all.addAssertion((Assertion)this.getAddressingAssertion());
        ProtectionToken ptoken = new ProtectionToken();
        binding.setProtectionToken(ptoken);
        binding.setIncludeTimestamp(true);
        binding.setEntireHeadersAndBodySignatures(true);
        binding.setTokenProtection(false);
        AlgorithmSuite suite = new AlgorithmSuite();
        binding.setAlgorithmSuite(suite);
        SecureConversationToken sct = new SecureConversationToken();
        sct.setOptional(true);
        ptoken.setToken(sct);
        SignedEncryptedParts parts = new SignedEncryptedParts(true);
        parts.setBody(true);
        parts.addHeader(new Header("To", this.addressingNamespace));
        parts.addHeader(new Header("From", this.addressingNamespace));
        parts.addHeader(new Header("FaultTo", this.addressingNamespace));
        parts.addHeader(new Header("ReplyTo", this.addressingNamespace));
        parts.addHeader(new Header("Action", this.addressingNamespace));
        parts.addHeader(new Header("MessageID", this.addressingNamespace));
        parts.addHeader(new Header("RelatesTo", this.addressingNamespace));
        all.addPolicyComponent((PolicyComponent)parts);
        this.client.getRequestContext().putAll(this.ctx);
        this.client.getRequestContext().put("org.apache.cxf.ws.policy.override", validatePolicy);
        this.client.getRequestContext().put("ws-security.token", tok);
        BindingOperationInfo boi = this.findOperation("/RST/Validate");
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + "/Validate");
        writer.writeEndElement();
        writer.writeStartElement("wst", "ValidateTarget", this.namespace);
        Element el = tok.getUnattachedReference();
        if (el == null) {
            el = tok.getAttachedReference();
        }
        StaxUtils.copy(el, (XMLStreamWriter)writer);
        writer.writeEndElement();
        writer.writeEndElement();
        this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
        return false;
    }

    public void cancelSecurityToken(SecurityToken token) throws Exception {
        this.createClient();
        if (this.isSecureConv) {
            this.client.getRequestContext().put("SOAPAction", this.namespace + "/RST/SCT/Cancel");
        }
        if (this.addressingNamespace == null) {
            this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        Policy cancelPolicy = new Policy();
        ExactlyOne one = new ExactlyOne();
        cancelPolicy.addPolicyComponent((PolicyComponent)one);
        All all = new All();
        one.addPolicyComponent((PolicyComponent)all);
        SymmetricBinding binding = new SymmetricBinding();
        all.addAssertion((Assertion)binding);
        all.addAssertion((Assertion)this.getAddressingAssertion());
        ProtectionToken ptoken = new ProtectionToken();
        binding.setProtectionToken(ptoken);
        binding.setIncludeTimestamp(true);
        binding.setEntireHeadersAndBodySignatures(true);
        binding.setTokenProtection(false);
        AlgorithmSuite suite = new AlgorithmSuite();
        binding.setAlgorithmSuite(suite);
        SecureConversationToken sct = new SecureConversationToken();
        sct.setOptional(true);
        ptoken.setToken(sct);
        SignedEncryptedParts parts = new SignedEncryptedParts(true);
        parts.setBody(true);
        parts.addHeader(new Header("To", this.addressingNamespace));
        parts.addHeader(new Header("From", this.addressingNamespace));
        parts.addHeader(new Header("FaultTo", this.addressingNamespace));
        parts.addHeader(new Header("ReplyTo", this.addressingNamespace));
        parts.addHeader(new Header("Action", this.addressingNamespace));
        parts.addHeader(new Header("MessageID", this.addressingNamespace));
        parts.addHeader(new Header("RelatesTo", this.addressingNamespace));
        all.addPolicyComponent((PolicyComponent)parts);
        this.client.getRequestContext().putAll(this.ctx);
        this.client.getRequestContext().put("org.apache.cxf.ws.policy.override", cancelPolicy);
        this.client.getRequestContext().put("ws-security.token", token);
        BindingOperationInfo boi = this.findOperation("/RST/Cancel");
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + "/Cancel");
        writer.writeEndElement();
        writer.writeStartElement("wst", "CancelTarget", this.namespace);
        Element el = token.getUnattachedReference();
        if (el == null) {
            el = token.getAttachedReference();
        }
        StaxUtils.copy(el, (XMLStreamWriter)writer);
        writer.writeEndElement();
        writer.writeEndElement();
        try {
            this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
            token.setState(SecurityToken.State.CANCELLED);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem cancelling token", ex);
        }
    }

    private String writeKeyType(W3CDOMStreamWriter writer, String keyType) throws XMLStreamException {
        if (this.isSecureConv) {
            this.addLifetime(writer);
            if (keyType == null) {
                writer.writeStartElement("wst", "TokenType", this.namespace);
                writer.writeCharacters(STSUtils.getTokenTypeSCT(this.namespace));
                writer.writeEndElement();
                keyType = this.namespace + "/SymmetricKey";
            }
        } else if (keyType == null) {
            writer.writeStartElement("wst", "KeyType", this.namespace);
            writer.writeCharacters(this.namespace + "/SymmetricKey");
            writer.writeEndElement();
            keyType = this.namespace + "/SymmetricKey";
        }
        return keyType;
    }

    private X509Certificate getCert(Crypto crypto) throws Exception {
        String alias = (String)this.getProperty("ws-security.sts.token.username");
        if (alias == null) {
            alias = crypto.getDefaultX509Alias();
        }
        if (alias == null) {
            Enumeration<String> as = crypto.getKeyStore().aliases();
            if (as.hasMoreElements()) {
                alias = as.nextElement();
            }
            if (as.hasMoreElements()) {
                throw new Fault("No alias specified for retrieving PublicKey", LOG);
            }
        }
        return crypto.getCertificates(alias)[0];
    }

    private void addLifetime(XMLStreamWriter writer) throws XMLStreamException {
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + (long)(this.ttl * 1000));
        XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
        writer.writeStartElement("wst", "Lifetime", this.namespace);
        writer.writeStartElement("wsu", "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        writer.writeCharacters(fmt.format(creationTime));
        writer.writeEndElement();
        writer.writeStartElement("wsu", "Expires", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        writer.writeCharacters(fmt.format(expirationTime));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void addAppliesTo(XMLStreamWriter writer, String appliesTo) throws XMLStreamException {
        if (appliesTo != null && this.addressingNamespace != null) {
            writer.writeStartElement("wsp", "AppliesTo", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeStartElement("wsa", "EndpointReference", this.addressingNamespace);
            writer.writeStartElement("wsa", "Address", this.addressingNamespace);
            writer.writeCharacters(appliesTo);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityToken createSecurityToken(Element el, byte[] requestorEntropy) throws WSSecurityException {
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement(el);
        }
        if (!"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            throw new Fault("Unexpected element " + el.getLocalName(), LOG);
        }
        el = DOMUtils.getFirstElement(el);
        Element rst = null;
        Element rar = null;
        Element rur = null;
        Element rpt = null;
        Element lte = null;
        Element entropy = null;
        while (el != null) {
            String ln = el.getLocalName();
            if (this.namespace.equals(el.getNamespaceURI())) {
                if ("Lifetime".equals(ln)) {
                    lte = el;
                } else if ("RequestedSecurityToken".equals(ln)) {
                    rst = DOMUtils.getFirstElement(el);
                } else if ("RequestedAttachedReference".equals(ln)) {
                    rar = DOMUtils.getFirstElement(el);
                } else if ("RequestedUnattachedReference".equals(ln)) {
                    rur = DOMUtils.getFirstElement(el);
                } else if ("RequestedProofToken".equals(ln)) {
                    rpt = el;
                } else if ("Entropy".equals(ln)) {
                    entropy = el;
                }
            }
            el = DOMUtils.getNextElement(el);
        }
        Element rstDec = rst;
        String id = this.findID(rar, rur, rstDec);
        if (StringUtils.isEmpty(id)) {
            throw new TrustException(new Message("NO_ID", LOG, new Object[0]));
        }
        SecurityToken token = new SecurityToken(id, rstDec, lte);
        token.setAttachedReference(rar);
        token.setUnattachedReference(rur);
        token.setIssuerAddress(this.location);
        byte[] secret = null;
        if (rpt != null) {
            Element child = DOMUtils.getFirstElement(rpt);
            QName childQname = DOMUtils.getElementQName(child);
            if (childQname.equals(new QName(this.namespace, "BinarySecret"))) {
                String b64Secret = DOMUtils.getContent(child);
                secret = Base64.decode((String)b64Secret);
            } else if (childQname.equals(new QName(this.namespace, "EncryptedKey"))) {
                try {
                    EncryptedKeyProcessor processor = new EncryptedKeyProcessor();
                    processor.handleToken(child, null, this.createCrypto(true), this.createHandler(), null, new Vector(), null);
                    secret = processor.getDecryptedBytes();
                }
                catch (IOException e) {
                    throw new TrustException(new Message("ENCRYPTED_KEY_ERROR", LOG, new Object[0]), (Throwable)e);
                }
            } else if (childQname.equals(new QName(this.namespace, "ComputedKey"))) {
                String content;
                Element binSecElem = entropy == null ? null : DOMUtils.getFirstElement(entropy);
                String string = content = binSecElem == null ? null : DOMUtils.getContent(binSecElem);
                if (content == null || StringUtils.isEmpty(content.trim())) throw new TrustException(new Message("NO_ENTROPY", LOG, new Object[0]));
                byte[] serviceEntr = Base64.decode((String)content);
                P_SHA1 psha1 = new P_SHA1();
                int length = this.keySize > 0 ? this.keySize : this.algorithmSuite.getMaximumSymmetricKeyLength();
                try {
                    secret = psha1.createKey(requestorEntropy, serviceEntr, 0, (long)(length / 8));
                }
                catch (ConversationException e) {
                    throw new TrustException(new Message("DERIVED_KEY_ERROR", LOG, new Object[0]), (Throwable)e);
                }
            }
        } else if (requestorEntropy != null) {
            secret = requestorEntropy;
        }
        token.setSecret(secret);
        return token;
    }

    private CallbackHandler createHandler() {
        Object o = this.getProperty("ws-security.callback-handler");
        if (o instanceof String) {
            try {
                Class<?> cls = ClassLoaderUtils.loadClass((String)o, this.getClass());
                o = cls.newInstance();
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
        return (CallbackHandler)o;
    }

    private Object getProperty(String s) {
        Object o = this.ctx.get(s);
        if (o == null) {
            o = this.client.getEndpoint().getEndpointInfo().getProperty(s);
        }
        if (o == null) {
            o = this.client.getEndpoint().getEndpointInfo().getBinding().getProperty(s);
        }
        if (o == null) {
            o = this.client.getEndpoint().getService().get(s);
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Crypto createCrypto(boolean decrypt) throws IOException {
        WSSConfig.getDefaultWSConfig();
        Crypto crypto = (Crypto)this.getProperty("ws-security.sts.token.crypto" + (decrypt ? ".decrypt" : ""));
        if (crypto != null) {
            return crypto;
        }
        Object o = this.getProperty("ws-security.sts.token.properties" + (decrypt ? ".decrypt" : ""));
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            ResourceManager rm = this.bus.getExtension(ResourceManager.class);
            URL url = rm.resolveResource((String)o, URL.class);
            if (url == null) {
                url = ClassLoaderUtils.getResource((String)o, this.getClass());
            }
            if (url == null) throw new Fault("Could not find properties file " + url, LOG);
            properties = new Properties();
            InputStream ins = url.openStream();
            properties.load(ins);
            ins.close();
        } else if (o instanceof URL) {
            properties = new Properties();
            InputStream ins = ((URL)o).openStream();
            properties.load(ins);
            ins.close();
        }
        if (properties != null) {
            return CryptoFactory.getInstance((Properties)properties);
        }
        if (!decrypt) return null;
        return this.createCrypto(false);
    }

    private String findID(Element rar, Element rur, Element rst) {
        String id = null;
        if (rst != null) {
            id = this.getIDFromSTR(rst);
        }
        if (id == null && rar != null) {
            id = this.getIDFromSTR(rar);
        }
        if (id == null && rur != null) {
            id = this.getIDFromSTR(rur);
        }
        if (id == null) {
            id = rst.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        return id;
    }

    private String getIDFromSTR(Element el) {
        Element child = DOMUtils.getFirstElement(el);
        if (child == null) {
            return null;
        }
        QName elName = DOMUtils.getElementQName(child);
        if (elName.equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) || elName.equals(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"))) {
            return DOMUtils.getContent(child);
        }
        if (elName.equals(Reference.TOKEN)) {
            return child.getAttribute("URI");
        }
        if (elName.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "Identifier")) || elName.equals(new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "Identifier"))) {
            return DOMUtils.getContent(child);
        }
        return null;
    }

    public void setTemplate(Element rstTemplate) {
        this.template = rstTemplate;
    }
}

